/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.allocationpolicies;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.cloudsimplus.allocationpolicies.VmAllocationPolicyNull;
import org.cloudsimplus.autoscaling.VerticalVmScaling;
import org.cloudsimplus.datacenters.Datacenter;
import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.hosts.HostSuitability;
import org.cloudsimplus.vms.Vm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface VmAllocationPolicy {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)VmAllocationPolicy.class.getSimpleName());
    public static final int DEF_HOST_COUNT_PARALLEL_SEARCH = 20000;
    public static final VmAllocationPolicy NULL = new VmAllocationPolicyNull();

    public Datacenter getDatacenter();

    public VmAllocationPolicy setDatacenter(Datacenter var1);

    public HostSuitability allocateHostForVm(Vm var1);

    public HostSuitability allocateHostForVm(Vm var1, Host var2);

    public <T extends Vm> List<T> allocateHostForVm(Collection<T> var1);

    public boolean scaleVmVertically(VerticalVmScaling var1);

    public void deallocateHostForVm(Vm var1);

    public VmAllocationPolicy setFindHostForVmFunction(BiFunction<VmAllocationPolicy, Vm, Optional<Host>> var1);

    public <T extends Host> List<T> getHostList();

    public Map<Vm, Host> getOptimizedAllocationMap(List<? extends Vm> var1);

    public Optional<Host> findHostForVm(Vm var1);

    public boolean isVmMigrationSupported();

    default public boolean isParallelHostSearchEnabled() {
        return this.getHostList().size() >= this.getHostCountForParallelSearch();
    }

    public int getHostCountForParallelSearch();

    public VmAllocationPolicy setHostCountForParallelSearch(int var1);
}

