/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.allocationpolicies;

import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Stream;
import org.cloudsimplus.allocationpolicies.VmAllocationPolicyAbstract;
import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.vms.Vm;

public class VmAllocationPolicyBestFit
extends VmAllocationPolicyAbstract {
    @Override
    protected Optional<Host> defaultFindHostForVm(Vm vm) {
        Comparator<Host> activeComparator = Comparator.comparing(Host::isActive).reversed();
        Comparator<Host> comparator = activeComparator.thenComparingLong(Host::getFreePesNumber);
        Stream stream = this.isParallelHostSearchEnabled() ? (Stream)this.getHostList().stream().parallel() : this.getHostList().stream();
        return stream.filter(host -> host.isSuitableForVm(vm)).min(comparator);
    }
}

