/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.allocationpolicies;

import java.util.Comparator;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.cloudsimplus.allocationpolicies.VmAllocationPolicy;
import org.cloudsimplus.allocationpolicies.VmAllocationPolicyAbstract;
import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.vms.Vm;

public class VmAllocationPolicySimple
extends VmAllocationPolicyAbstract {
    public VmAllocationPolicySimple() {
    }

    public VmAllocationPolicySimple(BiFunction<VmAllocationPolicy, Vm, Optional<Host>> findHostForVmFunction) {
        super(findHostForVmFunction);
    }

    @Override
    protected Optional<Host> defaultFindHostForVm(Vm vm) {
        Comparator<Host> comparator = Comparator.comparing(Host::isActive).thenComparingLong(Host::getFreePesNumber);
        Stream hostStream = this.isParallelHostSearchEnabled() ? (Stream)this.getHostList().stream().parallel() : this.getHostList().stream();
        return hostStream.filter(host -> host.isSuitableForVm(vm)).max(comparator);
    }
}

