/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.allocationpolicies.migration;

import lombok.NonNull;
import org.cloudsimplus.allocationpolicies.migration.VmAllocationPolicyMigration;
import org.cloudsimplus.allocationpolicies.migration.VmAllocationPolicyMigrationAbstract;
import org.cloudsimplus.allocationpolicies.migration.VmAllocationPolicyMigrationDynamicUpperThreshold;
import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.selectionpolicies.VmSelectionPolicy;

public abstract class VmAllocationPolicyMigrationDynamicUpperThresholdFirstFit
extends VmAllocationPolicyMigrationAbstract
implements VmAllocationPolicyMigrationDynamicUpperThreshold {
    private double safetyParameter;
    @NonNull
    private VmAllocationPolicyMigration fallbackVmAllocationPolicy;

    public VmAllocationPolicyMigrationDynamicUpperThresholdFirstFit(VmSelectionPolicy vmSelectionPolicy) {
        this(vmSelectionPolicy, 0.0, VmAllocationPolicyMigration.NULL);
    }

    public VmAllocationPolicyMigrationDynamicUpperThresholdFirstFit(VmSelectionPolicy vmSelectionPolicy, double safetyParameter, VmAllocationPolicyMigration fallbackVmAllocationPolicy) {
        super(vmSelectionPolicy);
        this.setSafetyParameter(safetyParameter);
        this.setFallbackVmAllocationPolicy(fallbackVmAllocationPolicy);
    }

    @Override
    public boolean isOverloaded(Host host) {
        if (this.getOverUtilizationThreshold(host) == Double.MAX_VALUE) {
            return this.getFallbackVmAllocationPolicy().isOverloaded(host);
        }
        return super.isOverloaded(host);
    }

    @Override
    public double getOverUtilizationThreshold(Host host) {
        try {
            return 1.0 - this.getSafetyParameter() * this.computeHostUtilizationMeasure(host);
        }
        catch (IllegalStateException e) {
            return Double.MAX_VALUE;
        }
    }

    protected final void setSafetyParameter(double safetyParameter) {
        if (safetyParameter < 0.0) {
            throw new IllegalArgumentException("The safety parameter must be a positive value. It is a percentage value in scale from 0 to 1 where, for instance, 1 means 100% and 1.5 means 150%.");
        }
        this.safetyParameter = safetyParameter;
    }

    @Override
    public final double getSafetyParameter() {
        return this.safetyParameter;
    }

    @Override
    @NonNull
    public final VmAllocationPolicyMigration getFallbackVmAllocationPolicy() {
        return this.fallbackVmAllocationPolicy;
    }

    @Override
    public final VmAllocationPolicyMigrationDynamicUpperThresholdFirstFit setFallbackVmAllocationPolicy(@NonNull VmAllocationPolicyMigration fallbackVmAllocationPolicy) {
        if (fallbackVmAllocationPolicy == null) {
            throw new NullPointerException("fallbackVmAllocationPolicy is marked non-null but is null");
        }
        this.fallbackVmAllocationPolicy = fallbackVmAllocationPolicy;
        return this;
    }
}

