/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.autoscaling;

import lombok.NonNull;
import org.cloudsimplus.autoscaling.VmScaling;
import org.cloudsimplus.vms.Vm;

public abstract class VmScalingAbstract
implements VmScaling {
    private double lastProcessingTime;
    @NonNull
    private Vm vm = Vm.NULL;

    protected VmScalingAbstract() {
    }

    protected boolean isTimeToCheckPredicate(double time) {
        return time > this.lastProcessingTime && (double)((long)time) % this.getVm().getHost().getDatacenter().getSchedulingInterval() == 0.0;
    }

    protected abstract boolean requestUpScaling(double var1);

    protected void setLastProcessingTime(double lastProcessingTime) {
        this.lastProcessingTime = lastProcessingTime;
    }

    @Override
    @NonNull
    public Vm getVm() {
        return this.vm;
    }

    @Override
    public VmScalingAbstract setVm(@NonNull Vm vm) {
        if (vm == null) {
            throw new NullPointerException("vm is marked non-null but is null");
        }
        this.vm = vm;
        return this;
    }
}

