/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.brokers;

import java.util.Comparator;
import org.cloudsimplus.brokers.DatacenterBrokerSimple;
import org.cloudsimplus.cloudlets.Cloudlet;
import org.cloudsimplus.core.CloudSimPlus;
import org.cloudsimplus.vms.Vm;

public class DatacenterBrokerBestFit
extends DatacenterBrokerSimple {
    public DatacenterBrokerBestFit(CloudSimPlus simulation) {
        super(simulation);
    }

    @Override
    public Vm defaultVmMapper(Cloudlet cloudlet) {
        if (cloudlet.isBoundToVm()) {
            return cloudlet.getVm();
        }
        Vm mappedVm = this.getVmCreatedList().stream().filter(vm -> vm.getExpectedFreePesNumber() >= cloudlet.getPesNumber()).min(Comparator.comparingLong(Vm::getExpectedFreePesNumber)).orElse(Vm.NULL);
        if (Vm.NULL.equals(mappedVm)) {
            LOGGER.warn("{}: {}: {} (PEs: {}) couldn't be mapped to any suitable VM.", new Object[]{this.getSimulation().clockStr(), this.getName(), cloudlet, cloudlet.getPesNumber()});
        } else {
            LOGGER.trace("{}: {}: {} (PEs: {}) mapped to {} (available PEs: {}, tot PEs: {})", new Object[]{this.getSimulation().clockStr(), this.getName(), cloudlet, cloudlet.getPesNumber(), mappedVm, mappedVm.getExpectedFreePesNumber(), mappedVm.getFreePesNumber()});
        }
        return mappedVm;
    }
}

