/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.brokers;

import java.util.stream.Collectors;
import lombok.NonNull;
import org.cloudsimplus.brokers.DatacenterBrokerSimple;
import org.cloudsimplus.cloudlets.Cloudlet;
import org.cloudsimplus.core.CloudSimPlus;
import org.cloudsimplus.heuristics.CloudletToVmMappingHeuristic;
import org.cloudsimplus.heuristics.CloudletToVmMappingSolution;
import org.cloudsimplus.vms.Vm;

public class DatacenterBrokerHeuristic
extends DatacenterBrokerSimple {
    @NonNull
    private CloudletToVmMappingHeuristic heuristic = CloudletToVmMappingHeuristic.NULL;

    public DatacenterBrokerHeuristic(CloudSimPlus simulation) {
        super(simulation);
    }

    @Override
    protected void requestDatacentersToCreateWaitingCloudlets() {
        this.setupAndStartHeuristic();
        super.requestDatacentersToCreateWaitingCloudlets();
    }

    private void setupAndStartHeuristic() {
        this.heuristic.setVmList(this.getVmExecList());
        this.heuristic.setCloudletList(this.getCloudletWaitingList().stream().filter(cloudlet -> !cloudlet.isBoundToVm()).collect(Collectors.toList()));
        LOGGER.info("{} started the heuristic to get a suboptimal solution for mapping Cloudlets to Vm's running {} neighborhood searches by iteration.{}{}", new Object[]{this, this.heuristic.getSearchesByIteration(), System.lineSeparator(), "Please wait... It may take a while, depending on heuristic parameters and number of Cloudlets and Vm's."});
        CloudletToVmMappingSolution solution = (CloudletToVmMappingSolution)this.heuristic.solve();
        LOGGER.info("{} finished the solution find for mapping Cloudlets to Vm's in {} seconds with a solution cost of {}", new Object[]{this, this.heuristic.getSolveTime(), solution.getCost()});
    }

    @Override
    public Vm defaultVmMapper(Cloudlet cloudlet) {
        Vm fallbackVm = super.defaultVmMapper(cloudlet);
        return ((CloudletToVmMappingSolution)this.heuristic.getBestSolutionSoFar()).getResult().getOrDefault(cloudlet, fallbackVm);
    }

    @NonNull
    public final CloudletToVmMappingHeuristic getHeuristic() {
        return this.heuristic;
    }

    public final DatacenterBrokerHeuristic setHeuristic(@NonNull CloudletToVmMappingHeuristic heuristic) {
        if (heuristic == null) {
            throw new NullPointerException("heuristic is marked non-null but is null");
        }
        this.heuristic = heuristic;
        return this;
    }
}

