/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.brokers;

import org.cloudsimplus.brokers.DatacenterBrokerAbstract;
import org.cloudsimplus.cloudlets.Cloudlet;
import org.cloudsimplus.core.CloudSimPlus;
import org.cloudsimplus.datacenters.Datacenter;
import org.cloudsimplus.vms.Vm;

public class DatacenterBrokerSimple
extends DatacenterBrokerAbstract {
    private int lastSelectedVmIndex = -1;
    private int lastSelectedDcIndex = -1;
    private int triedDatacenters;

    public DatacenterBrokerSimple(CloudSimPlus simulation) {
        this(simulation, "");
    }

    public DatacenterBrokerSimple(CloudSimPlus simulation, String name) {
        super(simulation, name);
    }

    @Override
    protected Datacenter defaultDatacenterMapper(Datacenter lastDatacenter, Vm vm) {
        if (this.getDatacenterList().isEmpty()) {
            throw new IllegalStateException("You don't have any Datacenter created.");
        }
        if (lastDatacenter != Datacenter.NULL) {
            return this.nextDatacenter(lastDatacenter);
        }
        if (this.triedDatacenters >= this.getDatacenterList().size()) {
            return Datacenter.NULL;
        }
        ++this.triedDatacenters;
        return this.getDatacenterList().get(++this.lastSelectedDcIndex % this.getDatacenterList().size());
    }

    private Datacenter nextDatacenter(Datacenter lastDatacenter) {
        if (this.lastSelectedDcIndex == -1) {
            this.lastSelectedDcIndex = this.getDatacenterList().indexOf(lastDatacenter);
        }
        return lastDatacenter;
    }

    @Override
    protected Vm defaultVmMapper(Cloudlet cloudlet) {
        if (cloudlet.isBoundToVm()) {
            return cloudlet.getVm();
        }
        if (this.getVmExecList().isEmpty()) {
            return Vm.NULL;
        }
        ++this.lastSelectedVmIndex;
        this.lastSelectedVmIndex %= this.getVmExecList().size();
        return this.getVmFromCreatedList(this.lastSelectedVmIndex);
    }
}

