/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.brokers;

public class VmCreation {
    public static final int DEF_CURRENT_VM_CREATION_RETRIES = 5;
    private double retryDelay;
    private int maxRetries;
    private int retries;
    private int creationRequests;

    public VmCreation() {
        this.retryDelay = 5.0;
        this.maxRetries = 5;
    }

    public VmCreation(double retryDelay, int maxRetries) {
        this.retryDelay = retryDelay;
        this.maxRetries = maxRetries;
    }

    public static VmCreation ofZero() {
        return new VmCreation(0.0, 0);
    }

    public boolean isRetryFailedVms() {
        return this.retryDelay > 0.0 && this.retries < this.maxRetries;
    }

    public void incCurrentRetries() {
        ++this.retries;
    }

    public void resetCurrentRetries() {
        this.retries = 5;
    }

    public void incCreationRequests(int value) {
        this.creationRequests += value;
    }

    public final double getRetryDelay() {
        return this.retryDelay;
    }

    public final int getMaxRetries() {
        return this.maxRetries;
    }

    public final int getRetries() {
        return this.retries;
    }

    public final int getCreationRequests() {
        return this.creationRequests;
    }

    public final VmCreation setRetryDelay(double retryDelay) {
        this.retryDelay = retryDelay;
        return this;
    }

    public final VmCreation setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }
}

