/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.cloudsimplus.brokers.DatacenterBroker;
import org.cloudsimplus.brokers.DatacenterBrokerSimple;
import org.cloudsimplus.builders.BrokerBuilderDecorator;
import org.cloudsimplus.builders.BrokerBuilderInterface;
import org.cloudsimplus.builders.SimulationScenarioBuilder;

public class BrokerBuilder
implements BrokerBuilderInterface {
    private final List<DatacenterBroker> brokers;
    private final SimulationScenarioBuilder scenario;

    public BrokerBuilder(SimulationScenarioBuilder scenario) {
        this.scenario = scenario;
        this.brokers = new ArrayList<DatacenterBroker>();
    }

    @Override
    public BrokerBuilderDecorator create() {
        return this.create(b -> {});
    }

    @Override
    public BrokerBuilderDecorator create(Consumer<DatacenterBroker> brokerConsumer) {
        DatacenterBrokerSimple broker = new DatacenterBrokerSimple(this.scenario.getSimulation());
        this.brokers.add(broker);
        brokerConsumer.accept(broker);
        return new BrokerBuilderDecorator(this, broker);
    }

    @Override
    public List<DatacenterBroker> getBrokers() {
        return this.brokers;
    }

    @Override
    public DatacenterBroker get(int index) {
        return this.brokers.get(index);
    }

    @Override
    public DatacenterBroker findBroker(int id) {
        return this.brokers.stream().filter(broker -> broker.getId() == (long)id).findFirst().orElseThrow(() -> new NoSuchElementException("There isn't a broker with id %d".formatted(id)));
    }
}

