/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.cloudsimplus.brokers.DatacenterBroker;
import org.cloudsimplus.brokers.DatacenterBrokerSimple;
import org.cloudsimplus.builders.BrokerBuilder;
import org.cloudsimplus.builders.BrokerBuilderInterface;
import org.cloudsimplus.builders.CloudletBuilder;
import org.cloudsimplus.builders.VmBuilder;

public class BrokerBuilderDecorator
implements BrokerBuilderInterface {
    private final BrokerBuilder builder;
    private final VmBuilder vmBuilder;
    private final CloudletBuilder cloudletBuilder;
    private final DatacenterBroker broker;

    public BrokerBuilderDecorator(BrokerBuilder builder, DatacenterBrokerSimple broker) {
        this.builder = Objects.requireNonNull(builder);
        this.broker = Objects.requireNonNull(broker);
        this.vmBuilder = new VmBuilder(broker);
        this.cloudletBuilder = new CloudletBuilder(this, broker);
    }

    @Override
    public BrokerBuilderDecorator create() {
        return this.builder.create();
    }

    @Override
    public BrokerBuilderDecorator create(Consumer<DatacenterBroker> brokerConsumer) {
        return this.builder.create(brokerConsumer);
    }

    @Override
    public List<DatacenterBroker> getBrokers() {
        return this.builder.getBrokers();
    }

    @Override
    public DatacenterBroker findBroker(int id) {
        return this.builder.findBroker(id);
    }

    @Override
    public DatacenterBroker get(int index) {
        return this.builder.get(index);
    }

    public VmBuilder getVmBuilder() {
        return this.vmBuilder;
    }

    public CloudletBuilder getCloudletBuilder() {
        return this.cloudletBuilder;
    }

    public DatacenterBroker getBroker() {
        return this.broker;
    }
}

