/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders.tables;

import java.util.Objects;
import org.cloudsimplus.builders.tables.Table;
import org.cloudsimplus.builders.tables.TableColumn;

public abstract class AbstractTableColumn
implements TableColumn {
    private String title;
    private String subTitle;
    private String format;
    private Table table;

    public AbstractTableColumn(Table table, String title) {
        this(table, title, "");
    }

    public AbstractTableColumn(String title, String subTitle, String format) {
        this.title = title;
        this.subTitle = subTitle;
        this.setFormat(format);
    }

    public AbstractTableColumn(Table table, String title, String subTitle) {
        this(title, subTitle);
        this.table = table;
    }

    public AbstractTableColumn(String title, String subTitle) {
        this(title, subTitle, "");
    }

    @Override
    public AbstractTableColumn setTitle(String title) {
        this.title = Objects.requireNonNullElse(title, "");
        return this;
    }

    @Override
    public AbstractTableColumn setSubTitle(String subTitle) {
        this.subTitle = Objects.requireNonNullElse(subTitle, "");
        return this;
    }

    @Override
    public final AbstractTableColumn setFormat(String format) {
        this.format = Objects.requireNonNullElse(format, "");
        return this;
    }

    public String toString() {
        return this.getTitle();
    }

    @Override
    public AbstractTableColumn setTable(Table table) {
        this.table = table;
        return this;
    }

    @Override
    public String generateData(Object data) {
        if (this.format.isBlank()) {
            return String.valueOf(data);
        }
        return this.format.formatted(data);
    }

    protected abstract String generateHeader(String var1);

    @Override
    public String generateTitleHeader() {
        return this.generateHeader(this.title);
    }

    @Override
    public String generateSubtitleHeader() {
        return this.generateHeader(this.subTitle);
    }

    @Override
    public int getIndex() {
        return this.table.getColumns().indexOf(this);
    }

    protected boolean isLastColumn() {
        return this.getIndex() == this.getTable().getColumns().size() - 1;
    }

    @Override
    public final String getTitle() {
        return this.title;
    }

    @Override
    public final String getSubTitle() {
        return this.subTitle;
    }

    @Override
    public final String getFormat() {
        return this.format;
    }

    @Override
    public final Table getTable() {
        return this.table;
    }
}

