/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders.tables;

import org.cloudsimplus.builders.tables.TableBuilderAbstract;
import org.cloudsimplus.builders.tables.TableColumn;
import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.hosts.HostStateHistoryEntry;

public class HostHistoryTableBuilder
extends TableBuilderAbstract<HostStateHistoryEntry> {
    private static final String MIPS = "MIPS";
    private final Host host;

    public HostHistoryTableBuilder(Host host) {
        super(host.getStateHistory());
        this.host = host;
    }

    @Override
    protected void createTableColumns() {
        TableColumn col1 = this.getTable().newColumn("Time ", "Secs", "%5.0f");
        this.addColumn(col1, HostStateHistoryEntry::time);
        String format = "%9.0f";
        TableColumn col2 = this.getTable().newColumn("Total Requested", MIPS, "%9.0f");
        this.addColumn(col2, HostStateHistoryEntry::requestedMips);
        TableColumn col3 = this.getTable().newColumn("Total Allocated", MIPS, "%9.0f");
        this.addColumn(col3, HostStateHistoryEntry::allocatedMips);
        TableColumn col4 = this.getTable().newColumn("Used ", "", "%3.0f%%");
        this.addColumn(col4, history -> history.percentUsage() * 100.0);
        this.addColumn(this.getTable().newColumn("Host Active"), HostStateHistoryEntry::active);
        TableColumn col5 = this.getTable().newColumn("Host Total MIPS", "", "%9.0f");
        this.addColumn(col5, history -> this.host.getTotalMipsCapacity());
        TableColumn col6 = this.getTable().newColumn("Host Total Usage", "", "%5.1f%%");
        this.addColumn(col6, history -> history.allocatedMips() / this.host.getTotalMipsCapacity() * 100.0);
    }
}

