/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders.tables;

import org.cloudsimplus.builders.tables.AbstractTableColumn;
import org.cloudsimplus.builders.tables.Table;

public class HtmlTableColumn
extends AbstractTableColumn {
    public HtmlTableColumn(String title, String subTitle) {
        this(title, subTitle, "");
    }

    public HtmlTableColumn(String title) {
        this(title, "", "");
    }

    public HtmlTableColumn(Table table, String title) {
        super(table, title);
    }

    public HtmlTableColumn(Table table, String title, String subTitle) {
        super(table, title, subTitle);
    }

    public HtmlTableColumn(String title, String subTitle, String format) {
        super(title, subTitle, format);
    }

    private String indentLine(int columnIndex) {
        return columnIndex == 0 ? "    " : "";
    }

    @Override
    protected String generateHeader(String str) {
        int index = this.getTable().getColumns().indexOf(this);
        return "%s<th>%s</th>".formatted(this.indentLine(index), str);
    }

    @Override
    public String generateData(Object data) {
        int index = this.getTable().getColumns().indexOf(this);
        return "%s<td>%s</td>".formatted(this.indentLine(index), super.generateData(data));
    }
}

