/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders.tables;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;
import org.cloudsimplus.builders.tables.AbstractTable;
import org.cloudsimplus.builders.tables.ColumnMapping;
import org.cloudsimplus.builders.tables.MarkdownTable;
import org.cloudsimplus.builders.tables.Table;
import org.cloudsimplus.builders.tables.TableColumn;

public abstract class TableBuilderAbstract<T> {
    private List<? extends T> list;
    private List<ColumnMapping<T>> colsMappings;
    private Table table;

    public TableBuilderAbstract(List<? extends T> list) {
        this(list, new MarkdownTable());
    }

    public TableBuilderAbstract(List<? extends T> list, Table table) {
        this.setTable(table);
        this.setObjectList(list);
        this.colsMappings = new ArrayList<ColumnMapping<T>>();
    }

    protected final TableBuilderAbstract<T> setObjectList(List<? extends T> list) {
        this.list = Objects.requireNonNull(list);
        return this;
    }

    public TableBuilderAbstract<T> setTitle(String title) {
        this.table.setTitle(title);
        return this;
    }

    public final TableBuilderAbstract<T> column(int index, @NonNull Consumer<TableColumn> consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        consumer.accept(this.table.getColumns().get(index));
        return this;
    }

    protected final TableBuilderAbstract<T> setTable(@NonNull Table table) {
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        this.table = table;
        return this;
    }

    public TableBuilderAbstract<T> addColumn(TableColumn col, Function<T, Object> dataFunction) {
        return this.addColumn(col, dataFunction, Integer.MAX_VALUE);
    }

    public TableBuilderAbstract<T> addColumn(@NonNull TableColumn col, @NonNull Function<T, Object> dataFunction, int index) {
        if (col == null) {
            throw new NullPointerException("col is marked non-null but is null");
        }
        if (dataFunction == null) {
            throw new NullPointerException("dataFunction is marked non-null but is null");
        }
        this.colsMappings.add(new ColumnMapping<T>(col, dataFunction, index));
        return this;
    }

    public final TableBuilderAbstract<T> removeColumn(int ... indexes) {
        for (int i : indexes) {
            this.removeColumn(i);
        }
        return this;
    }

    public final TableBuilderAbstract<T> removeColumn(int index) {
        this.table.getColumns().remove(index);
        return this;
    }

    public void build() {
        this.createAndAddTableColumns();
        if (this.table.getTitle().isEmpty()) {
            this.table.setTitle("SIMULATION RESULTS");
        }
        this.list.forEach(cloudlet -> this.addDataToRow(cloudlet, this.table.newRow()));
        this.table.print();
    }

    private void createAndAddTableColumns() {
        this.createTableColumns();
        AbstractTable tb = (AbstractTable)this.table;
        this.colsMappings.forEach(mapping -> tb.addColumn(mapping.col(), mapping.index()));
    }

    protected abstract void createTableColumns();

    protected void addDataToRow(T object, List<Object> row) {
        this.colsMappings.forEach(mapping -> row.add(mapping.getColData(object)));
    }

    public final Table getTable() {
        return this.table;
    }
}

