/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders.tables;

import org.cloudsimplus.builders.tables.CsvTable;
import org.cloudsimplus.builders.tables.TableColumn;
import org.cloudsimplus.builders.tables.TextTableColumn;

public class TextTable
extends CsvTable {
    public TextTable() {
        this("");
    }

    public TextTable(String title) {
        super(title);
        this.setColumnSeparator("|");
    }

    @Override
    public void printTitle() {
        if (!this.getTitle().isBlank()) {
            this.getPrintStream().println(this.getCentralizedString(this.getTitle()));
        }
    }

    @Override
    public void printTableOpening() {
        this.getPrintStream().println();
    }

    @Override
    protected void printColumnHeaders() {
        super.printColumnHeaders();
        this.getPrintStream().printf(this.createHorizontalLine(false), new Object[0]);
    }

    @Override
    public void printTableClosing() {
        this.getPrintStream().printf(this.createHorizontalLine(false), new Object[0]);
    }

    @Override
    public String getLineSeparator() {
        return "-";
    }

    @Override
    public TableColumn newColumn(String title, String subtitle, String format) {
        return new TextTableColumn(title, subtitle, format);
    }
}

