/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.cloudlets;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import org.cloudsimplus.brokers.DatacenterBroker;
import org.cloudsimplus.cloudlets.Cloudlet;
import org.cloudsimplus.core.CloudInformationService;
import org.cloudsimplus.core.CloudSimTag;
import org.cloudsimplus.core.CustomerEntityAbstract;
import org.cloudsimplus.datacenters.Datacenter;
import org.cloudsimplus.listeners.CloudletVmEventInfo;
import org.cloudsimplus.listeners.EventInfo;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.resources.Bandwidth;
import org.cloudsimplus.resources.Pe;
import org.cloudsimplus.resources.Processor;
import org.cloudsimplus.resources.Ram;
import org.cloudsimplus.resources.ResourceManageable;
import org.cloudsimplus.utilizationmodels.UtilizationModel;
import org.cloudsimplus.utilizationmodels.UtilizationModelFull;
import org.cloudsimplus.vms.Vm;
import org.cloudsimplus.vms.VmGroup;

public abstract class CloudletAbstract
extends CustomerEntityAbstract
implements Cloudlet {
    private long jobId;
    private long pesNumber;
    @NonNull
    private Cloudlet.Status status;
    private long length;
    private long finishedLengthSoFar;
    private boolean returnedToBroker;
    private int priority;
    private int netServiceLevel;
    private long fileSize;
    private long outputSize;
    private double arrivalTime;
    private double execStartTime;
    private double finishTime;
    private double lifeTime;
    private double submissionDelay;
    @NonNull
    private Vm vm;
    @NonNull
    private UtilizationModel utilizationModelCpu;
    @NonNull
    private UtilizationModel utilizationModelRam;
    @NonNull
    private UtilizationModel utilizationModelBw;
    private List<String> requiredFiles = new LinkedList<String>();
    private final Set<EventListener<CloudletVmEventInfo>> onStartListeners;
    private final Set<EventListener<CloudletVmEventInfo>> onFinishListeners;
    private final Set<EventListener<CloudletVmEventInfo>> onUpdateProcessingListeners;

    public CloudletAbstract(long length, int pesNumber, UtilizationModel utilizationModel) {
        this(-1L, length, pesNumber);
        this.setUtilizationModel(utilizationModel);
    }

    public CloudletAbstract(long length, int pesNumber) {
        this(-1L, length, pesNumber);
    }

    public CloudletAbstract(long length, long pesNumber) {
        this(-1L, length, pesNumber);
    }

    public CloudletAbstract(long id, long length, long pesNumber) {
        this.setId(id);
        this.setJobId(-1L);
        this.setPesNumber(pesNumber);
        this.setLength(length);
        this.setFileSize(1L);
        this.setOutputSize(1L);
        this.setSubmissionDelay(0.0);
        this.setArrivalTime(-1.0);
        this.reset();
        this.setUtilizationModelCpu(new UtilizationModelFull());
        this.setUtilizationModelRam(UtilizationModel.NULL);
        this.setUtilizationModelBw(UtilizationModel.NULL);
        this.onStartListeners = new HashSet<EventListener<CloudletVmEventInfo>>();
        this.onFinishListeners = new HashSet<EventListener<CloudletVmEventInfo>>();
        this.onUpdateProcessingListeners = new HashSet<EventListener<CloudletVmEventInfo>>();
    }

    @Override
    public final Cloudlet reset() {
        this.netServiceLevel = 0;
        this.execStartTime = 0.0;
        this.status = Cloudlet.Status.INSTANTIATED;
        this.priority = 0;
        this.setBroker(DatacenterBroker.NULL);
        this.setFinishTime(-1.0);
        this.vm = Vm.NULL;
        this.setExecStartTime(0.0);
        this.setArrivedTime(0.0);
        this.setCreationTime(0.0);
        this.setLifeTime(-1.0);
        this.setLastTriedDatacenter(Datacenter.NULL);
        return this;
    }

    @Override
    public Cloudlet setUtilizationModel(@NonNull UtilizationModel utilizationModel) {
        if (utilizationModel == null) {
            throw new NullPointerException("utilizationModel is marked non-null but is null");
        }
        this.setUtilizationModelBw(utilizationModel);
        this.setUtilizationModelRam(utilizationModel);
        this.setUtilizationModelCpu(utilizationModel);
        return this;
    }

    @Override
    public Cloudlet addOnUpdateProcessingListener(@NonNull EventListener<CloudletVmEventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.onUpdateProcessingListeners.add(listener);
        return this;
    }

    @Override
    public boolean removeOnUpdateProcessingListener(@NonNull EventListener<CloudletVmEventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        return this.onUpdateProcessingListeners.remove(listener);
    }

    @Override
    public Cloudlet addOnStartListener(@NonNull EventListener<CloudletVmEventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.onStartListeners.add(listener);
        return this;
    }

    @Override
    public boolean removeOnStartListener(@NonNull EventListener<CloudletVmEventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        return this.onStartListeners.remove(listener);
    }

    @Override
    public Cloudlet addOnFinishListener(@NonNull EventListener<CloudletVmEventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        if (listener.equals(EventListener.NULL)) {
            return this;
        }
        this.onFinishListeners.add(listener);
        return this;
    }

    @Override
    public boolean removeOnFinishListener(EventListener<CloudletVmEventInfo> listener) {
        return this.onFinishListeners.remove(listener);
    }

    @Override
    public void notifyOnUpdateProcessingListeners(double time) {
        this.onUpdateProcessingListeners.forEach(listener -> listener.update(CloudletVmEventInfo.of((EventListener<? extends EventInfo>)listener, time, this)));
    }

    @Override
    public Cloudlet setNetServiceLevel(int netServiceLevel) {
        if (netServiceLevel < 0) {
            throw new IllegalArgumentException("Net Service Level cannot be negative");
        }
        this.netServiceLevel = netServiceLevel;
        return this;
    }

    @Override
    public double getWaitingTime() {
        return this.arrivalTime == -1.0 ? -1.0 : this.execStartTime - this.arrivalTime;
    }

    @Override
    public final Cloudlet setPesNumber(long pesNumber) {
        if (pesNumber <= 0L) {
            throw new IllegalArgumentException("Cloudlet number of PEs has to be greater than zero.");
        }
        this.pesNumber = pesNumber;
        return this;
    }

    @Override
    public long getFinishedLengthSoFar() {
        if (this.getLength() > 0L) {
            return Math.min(this.finishedLengthSoFar, this.absLength());
        }
        return this.finishedLengthSoFar;
    }

    @Override
    public boolean isFinished() {
        return this.getLifeTime() > 0.0 && this.getActualCpuTime() >= this.getLifeTime() || this.getLength() > 0L && this.getFinishedLengthSoFar() >= this.getLength();
    }

    @Override
    public boolean addFinishedLengthSoFar(long partialFinishedMI) {
        if ((double)partialFinishedMI < 0.0 || this.arrivalTime == -1.0) {
            return false;
        }
        long maxLengthToAdd = this.getLength() < 0L ? partialFinishedMI : Math.min(partialFinishedMI, this.absLength() - this.getFinishedLengthSoFar());
        this.finishedLengthSoFar += maxLengthToAdd;
        this.returnToBrokerIfFinished();
        return true;
    }

    private void returnToBrokerIfFinished() {
        if (this.isFinished() && !this.isReturnedToBroker()) {
            this.returnedToBroker = true;
            CloudInformationService targetEntity = this.getSimulation().getCis();
            this.getSimulation().sendNow(targetEntity, this.getBroker(), CloudSimTag.CLOUDLET_RETURN, this);
            this.vm.getCloudletScheduler().addCloudletToReturnedList(this);
        }
    }

    void notifyOnFinishListeners() {
        if (this.isFinished()) {
            this.onFinishListeners.forEach(listener -> listener.update(CloudletVmEventInfo.of(listener, this)));
            this.onFinishListeners.clear();
        }
    }

    @Override
    public void setExecStartTime(double clockTime) {
        boolean isStartingInSomeVm = this.execStartTime <= 0.0 && clockTime > 0.0 && this.vm != Vm.NULL && this.vm != null;
        this.execStartTime = clockTime;
        if (isStartingInSomeVm) {
            this.onStartListeners.forEach(listener -> listener.update(CloudletVmEventInfo.of((EventListener<? extends EventInfo>)listener, clockTime, this)));
        }
    }

    @Override
    public final Cloudlet setLength(long length) {
        if (length == 0L) {
            throw new IllegalArgumentException("Cloudlet length cannot be zero.");
        }
        this.length = length;
        return this;
    }

    protected long absLength() {
        return Math.abs(this.getLength());
    }

    @Override
    public long getTotalLength() {
        return this.length * this.pesNumber;
    }

    @Override
    public double getActualCpuTime() {
        double time = this.getFinishTime() == -1.0 ? this.getSimulation().clock() : this.finishTime;
        return time - this.execStartTime;
    }

    protected final void setArrivalTime(double arrivalTime) {
        this.arrivalTime = arrivalTime < 0.0 ? -1.0 : arrivalTime;
    }

    protected final void setFinishTime(double finishTime) {
        this.finishTime = finishTime;
    }

    @Override
    public boolean setStatus(Cloudlet.Status newStatus) {
        if (this.status == newStatus) {
            return false;
        }
        if (newStatus == Cloudlet.Status.SUCCESS) {
            this.setFinishTime(this.getSimulation().clock());
        }
        this.status = newStatus;
        return true;
    }

    public final void setRequiredFiles(@NonNull List<String> requiredFiles) {
        if (requiredFiles == null) {
            throw new NullPointerException("requiredFiles is marked non-null but is null");
        }
        this.requiredFiles = requiredFiles;
    }

    @Override
    public boolean addRequiredFile(String fileName) {
        if (this.getRequiredFiles().stream().anyMatch(reqFile -> reqFile.equals(fileName))) {
            return false;
        }
        this.requiredFiles.add(fileName);
        return true;
    }

    @Override
    public boolean addRequiredFiles(List<String> fileNames) {
        boolean atLeastOneFileAdded = false;
        for (String fileName : fileNames) {
            atLeastOneFileAdded |= this.addRequiredFile(fileName);
        }
        return atLeastOneFileAdded;
    }

    @Override
    public boolean deleteRequiredFile(String filename) {
        for (int i = 0; i < this.getRequiredFiles().size(); ++i) {
            String currentFile = this.requiredFiles.get(i);
            if (!currentFile.equals(filename)) continue;
            this.requiredFiles.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasRequiresFiles() {
        return !this.getRequiredFiles().isEmpty();
    }

    @Override
    public UtilizationModel getUtilizationModel(Class<? extends ResourceManageable> resourceClass) {
        if (resourceClass.isAssignableFrom(Ram.class)) {
            return this.utilizationModelRam;
        }
        if (resourceClass.isAssignableFrom(Bandwidth.class)) {
            return this.utilizationModelBw;
        }
        if (resourceClass.isAssignableFrom(Processor.class) || resourceClass.isAssignableFrom(Pe.class)) {
            return this.utilizationModelCpu;
        }
        throw new UnsupportedOperationException("This class doesn't support " + resourceClass.getSimpleName() + " resources");
    }

    @Override
    public double getUtilizationOfCpu() {
        return this.getUtilizationOfCpu(this.getSimulation().clock());
    }

    @Override
    public double getUtilizationOfCpu(double time) {
        return this.getUtilizationModelCpu().getUtilization(time);
    }

    @Override
    public double getUtilizationOfBw() {
        return this.getUtilizationOfBw(this.getSimulation().clock());
    }

    @Override
    public double getUtilizationOfBw(double time) {
        return this.getUtilizationModelBw().getUtilization(time);
    }

    @Override
    public double getUtilizationOfRam() {
        return this.getUtilizationOfRam(this.getSimulation().clock());
    }

    @Override
    public double getUtilizationOfRam(double time) {
        return this.getUtilizationModelRam().getUtilization(time);
    }

    @Override
    public final void setSubmissionDelay(double submissionDelay) {
        if (submissionDelay < 0.0) {
            return;
        }
        this.submissionDelay = submissionDelay;
    }

    @Override
    public boolean isDelayed() {
        return this.submissionDelay > 0.0;
    }

    @Override
    public boolean isBoundToVm() {
        return this.vm != null && this.vm != Vm.NULL && !(this.vm instanceof VmGroup) && this.getBroker().equals(this.getVm().getBroker());
    }

    @Override
    public final Cloudlet setFileSize(long fileSize) {
        if (fileSize <= 0L) {
            throw new IllegalArgumentException("Cloudlet file size has to be greater than zero.");
        }
        this.fileSize = fileSize;
        return this;
    }

    @Override
    public final Cloudlet setOutputSize(long outputSize) {
        if (outputSize <= 0L) {
            throw new IllegalArgumentException("Cloudlet output size has to be greater than zero.");
        }
        this.outputSize = outputSize;
        return this;
    }

    @Override
    public Cloudlet setSizes(long size) {
        this.setFileSize(size);
        this.setOutputSize(size);
        return this;
    }

    @Override
    public double registerArrivalInDatacenter() {
        this.setArrivalTime(this.getSimulation().clock());
        return this.arrivalTime;
    }

    @Override
    public Cloudlet setLifeTime(double lifeTime) {
        if (lifeTime == 0.0) {
            throw new IllegalArgumentException("Cloudlet lifeTime cannot be zero.");
        }
        this.lifeTime = lifeTime;
        return this;
    }

    @Override
    public long getJobId() {
        return this.jobId;
    }

    @Override
    public long getPesNumber() {
        return this.pesNumber;
    }

    @Override
    @NonNull
    public Cloudlet.Status getStatus() {
        return this.status;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public boolean isReturnedToBroker() {
        return this.returnedToBroker;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int getNetServiceLevel() {
        return this.netServiceLevel;
    }

    @Override
    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    public long getOutputSize() {
        return this.outputSize;
    }

    @Override
    public double getArrivalTime() {
        return this.arrivalTime;
    }

    @Override
    public double getExecStartTime() {
        return this.execStartTime;
    }

    @Override
    public double getFinishTime() {
        return this.finishTime;
    }

    @Override
    public double getLifeTime() {
        return this.lifeTime;
    }

    @Override
    public double getSubmissionDelay() {
        return this.submissionDelay;
    }

    @Override
    @NonNull
    public Vm getVm() {
        return this.vm;
    }

    @Override
    @NonNull
    public UtilizationModel getUtilizationModelCpu() {
        return this.utilizationModelCpu;
    }

    @Override
    @NonNull
    public UtilizationModel getUtilizationModelRam() {
        return this.utilizationModelRam;
    }

    @Override
    @NonNull
    public UtilizationModel getUtilizationModelBw() {
        return this.utilizationModelBw;
    }

    @Override
    public List<String> getRequiredFiles() {
        return this.requiredFiles;
    }

    @Override
    public CloudletAbstract setJobId(long jobId) {
        this.jobId = jobId;
        return this;
    }

    @Override
    public CloudletAbstract setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public CloudletAbstract setVm(@NonNull Vm vm) {
        if (vm == null) {
            throw new NullPointerException("vm is marked non-null but is null");
        }
        this.vm = vm;
        return this;
    }

    @Override
    public CloudletAbstract setUtilizationModelCpu(@NonNull UtilizationModel utilizationModelCpu) {
        if (utilizationModelCpu == null) {
            throw new NullPointerException("utilizationModelCpu is marked non-null but is null");
        }
        this.utilizationModelCpu = utilizationModelCpu;
        return this;
    }

    @Override
    public CloudletAbstract setUtilizationModelRam(@NonNull UtilizationModel utilizationModelRam) {
        if (utilizationModelRam == null) {
            throw new NullPointerException("utilizationModelRam is marked non-null but is null");
        }
        this.utilizationModelRam = utilizationModelRam;
        return this;
    }

    @Override
    public CloudletAbstract setUtilizationModelBw(@NonNull UtilizationModel utilizationModelBw) {
        if (utilizationModelBw == null) {
            throw new NullPointerException("utilizationModelBw is marked non-null but is null");
        }
        this.utilizationModelBw = utilizationModelBw;
        return this;
    }
}

