/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.cloudlets.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.cloudsimplus.cloudlets.network.CloudletTask;
import org.cloudsimplus.network.VmPacket;
import org.cloudsimplus.vms.Vm;

public class CloudletReceiveTask
extends CloudletTask {
    private final List<VmPacket> packetsReceived = new ArrayList<VmPacket>();
    private long expectedPacketsToReceive;
    @NonNull
    private final Vm sourceVm;

    public CloudletReceiveTask(int id, Vm sourceVm) {
        super(id);
        this.sourceVm = sourceVm;
    }

    public void receivePacket(VmPacket packet) {
        packet.setReceiveTime(this.getCloudlet().getSimulation().clock());
        this.packetsReceived.add(packet);
        boolean finished = (long)this.packetsReceived.size() >= this.expectedPacketsToReceive;
        this.setFinished(finished);
    }

    public List<VmPacket> getPacketsReceived() {
        return Collections.unmodifiableList(this.packetsReceived);
    }

    public final long getExpectedPacketsToReceive() {
        return this.expectedPacketsToReceive;
    }

    @NonNull
    public final Vm getSourceVm() {
        return this.sourceVm;
    }

    public final CloudletReceiveTask setExpectedPacketsToReceive(long expectedPacketsToReceive) {
        this.expectedPacketsToReceive = expectedPacketsToReceive;
        return this;
    }
}

