/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.cloudlets.network;

import lombok.NonNull;
import org.cloudsimplus.cloudlets.network.CloudletExecutionTask;
import org.cloudsimplus.cloudlets.network.CloudletReceiveTask;
import org.cloudsimplus.cloudlets.network.CloudletSendTask;
import org.cloudsimplus.cloudlets.network.NetworkCloudlet;
import org.cloudsimplus.core.Identifiable;

public abstract class CloudletTask
implements Identifiable {
    private long id;
    private double startTime;
    private double finishTime;
    private long memory;
    @NonNull
    private NetworkCloudlet cloudlet;

    public CloudletTask(int id) {
        this.id = id;
        this.startTime = -1.0;
        this.finishTime = -1.0;
        this.memory = 0L;
    }

    public boolean isFinished() {
        return this.finishTime > -1.0;
    }

    public boolean isActive() {
        return !this.isFinished();
    }

    protected void setFinished(boolean finished) {
        if (this.isFinished() && !finished) {
            throw new IllegalStateException("The task is already finished. You cannot set it as unfinished.");
        }
        if (this.isActive() && finished) {
            this.finishTime = this.cloudlet.getSimulation().clock();
        }
    }

    public double getFinishTime() {
        return this.finishTime;
    }

    public boolean isExecutionTask() {
        return this instanceof CloudletExecutionTask;
    }

    public boolean isSendTask() {
        return this instanceof CloudletSendTask;
    }

    public boolean isReceiveTask() {
        return this instanceof CloudletReceiveTask;
    }

    @Override
    public final long getId() {
        return this.id;
    }

    public final double getStartTime() {
        return this.startTime;
    }

    public final long getMemory() {
        return this.memory;
    }

    @NonNull
    public final NetworkCloudlet getCloudlet() {
        return this.cloudlet;
    }

    public final CloudletTask setId(long id) {
        this.id = id;
        return this;
    }

    public final CloudletTask setStartTime(double startTime) {
        this.startTime = startTime;
        return this;
    }

    public final CloudletTask setMemory(long memory) {
        this.memory = memory;
        return this;
    }

    public final CloudletTask setCloudlet(@NonNull NetworkCloudlet cloudlet) {
        if (cloudlet == null) {
            throw new NullPointerException("cloudlet is marked non-null but is null");
        }
        this.cloudlet = cloudlet;
        return this;
    }
}

