/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.cloudlets.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.cloudsimplus.cloudlets.CloudletSimple;
import org.cloudsimplus.cloudlets.network.CloudletExecutionTask;
import org.cloudsimplus.cloudlets.network.CloudletTask;
import org.cloudsimplus.vms.Vm;
import org.cloudsimplus.vms.network.NetworkVm;

public class NetworkCloudlet
extends CloudletSimple {
    private int currentTaskNum = -1;
    private final List<CloudletTask> tasks = new ArrayList<CloudletTask>();

    public NetworkCloudlet(long length, int pesNumber) {
        this(-1, length, pesNumber);
    }

    public NetworkCloudlet(int id, long length, int pesNumber) {
        super((long)id, length, pesNumber);
    }

    public double getNumberOfTasks() {
        return this.tasks.size();
    }

    public List<CloudletTask> getTasks() {
        return Collections.unmodifiableList(this.tasks);
    }

    public boolean isTasksStarted() {
        return this.currentTaskNum > -1;
    }

    public boolean startNextTaskIfCurrentIsFinished(double nextTaskStartTime) {
        return this.getNextTaskIfCurrentIfFinished().map(task -> NetworkCloudlet.startTask(task, nextTaskStartTime)).isPresent();
    }

    private static CloudletTask startTask(CloudletTask task, double time) {
        task.setStartTime(time);
        return task;
    }

    public Optional<CloudletTask> getCurrentTask() {
        if (this.currentTaskNum < 0 || this.currentTaskNum >= this.tasks.size()) {
            return Optional.empty();
        }
        return Optional.of(this.tasks.get(this.currentTaskNum));
    }

    private Optional<CloudletTask> getNextTaskIfCurrentIfFinished() {
        if (this.getCurrentTask().filter(CloudletTask::isActive).isPresent()) {
            return Optional.empty();
        }
        if (this.currentTaskNum <= this.tasks.size() - 1) {
            ++this.currentTaskNum;
        }
        return this.getCurrentTask();
    }

    @Override
    public boolean isFinished() {
        boolean allTasksFinished = this.tasks.stream().allMatch(CloudletTask::isFinished);
        return super.isFinished() && allTasksFinished;
    }

    @Override
    public long getLength() {
        return this.getTasks().stream().filter(CloudletTask::isExecutionTask).map(task -> (CloudletExecutionTask)task).mapToLong(CloudletExecutionTask::getLength).sum();
    }

    public NetworkCloudlet addTask(@NonNull CloudletTask task) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        task.setCloudlet(this);
        this.tasks.add(task);
        return this;
    }

    @Override
    public NetworkVm getVm() {
        return (NetworkVm)super.getVm();
    }

    @Override
    public NetworkCloudlet setVm(Vm vm) {
        if (vm == Vm.NULL) {
            this.setVm(NetworkVm.NULL);
            return this;
        }
        if (vm instanceof NetworkVm) {
            super.setVm(vm);
            return this;
        }
        throw new IllegalArgumentException("NetworkCloudlet can just be executed by a NetworkVm");
    }
}

