/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.core;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.NonNull;
import org.cloudsimplus.core.CloudInformationService;
import org.cloudsimplus.core.CloudSimEntity;
import org.cloudsimplus.core.CloudSimTag;
import org.cloudsimplus.core.SimEntity;
import org.cloudsimplus.core.Simulation;
import org.cloudsimplus.core.events.CloudSimEvent;
import org.cloudsimplus.core.events.DeferredQueue;
import org.cloudsimplus.core.events.EventQueue;
import org.cloudsimplus.core.events.FutureQueue;
import org.cloudsimplus.core.events.SimEvent;
import org.cloudsimplus.datacenters.Datacenter;
import org.cloudsimplus.network.topologies.NetworkTopology;
import org.cloudsimplus.util.TimeUtil;
import org.cloudsimplus.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class CloudSim
implements Simulation {
    public static final String VERSION = "CloudSim Plus 8.0.0";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)CloudSim.class.getSimpleName());
    @NonNull
    private NetworkTopology networkTopology;
    private final CloudInformationService cis;
    private final Calendar calendar;
    private double terminationTime = -1.0;
    private double lastCloudletProcessingUpdate;
    private double newTerminationTime = -1.0;
    private final double minTimeBetweenEvents;
    private final List<CloudSimEntity> entityList = new ArrayList<CloudSimEntity>();
    private final FutureQueue future = new FutureQueue();
    private final DeferredQueue deferred = new DeferredQueue();
    private double clock = 0.0;
    private boolean running = false;
    private final Map<SimEntity, Predicate<SimEvent>> waitPredicates = new HashMap<SimEntity, Predicate<SimEvent>>();
    private boolean paused;
    private double pauseAt = -1.0;
    private boolean abortRequested;
    private boolean aborted;
    private boolean alreadyRunOnce = false;

    public CloudSim() {
        this(0.1);
    }

    public CloudSim(double minTimeBetweenEvents) {
        this.networkTopology = NetworkTopology.NULL;
        this.calendar = Calendar.getInstance();
        if (minTimeBetweenEvents <= 0.0) {
            throw new IllegalArgumentException("The minimal time between events should be positive, but is: " + minTimeBetweenEvents);
        }
        this.minTimeBetweenEvents = minTimeBetweenEvents;
        this.cis = new CloudInformationService(this);
    }

    protected void finish() {
        if (this.abortRequested) {
            return;
        }
        this.notifyEndOfSimulationToEntities();
        LOGGER.info("Simulation: No more future events{}", (Object)System.lineSeparator());
        if (!this.abortRequested) {
            for (int i = 0; i < this.entityList.size(); ++i) {
                this.entityList.get(i).run();
            }
        }
        this.shutdownEntities();
        this.running = false;
        this.printSimulationFinished();
    }

    private void shutdownEntities() {
        for (int i = 0; i < this.entityList.size(); ++i) {
            this.entityList.get(i).shutdown();
        }
    }

    @Override
    public double start() {
        this.aborted = false;
        this.startSync();
        while (this.processEvents(Double.MAX_VALUE)) {
        }
        this.finish();
        return this.clock;
    }

    @Override
    public void startSync() {
        if (this.alreadyRunOnce) {
            throw new UnsupportedOperationException("You can't run a simulation that has already run previously. If you've paused the simulation and want to resume it, call the resume() method.");
        }
        LOGGER.info("{}================== Starting {} =================={}", new Object[]{System.lineSeparator(), VERSION, System.lineSeparator()});
        this.startEntitiesIfNotRunning();
        this.alreadyRunOnce = true;
    }

    protected boolean processEvents(double until) {
        if (!this.runClockTickAndProcessFutureEvents(until) && !this.isToWaitClockToReachTerminationTime()) {
            return false;
        }
        this.notifyOnSimulationStartListeners();
        if (this.logSimulationAborted()) {
            return false;
        }
        if (this.isTimeToTerminateSimulationUnderRequest()) {
            if (this.newTerminationTime != -1.0 && this.clock >= this.newTerminationTime) {
                return false;
            }
            if (this.newTerminationTime == -1.0) {
                this.newTerminationTime = Math.max(this.terminationTime, this.clock) + this.minTimeBetweenEvents * 2.0;
            }
        }
        this.checkIfSimulationPauseRequested();
        return true;
    }

    protected abstract void notifyOnSimulationStartListeners();

    private boolean logSimulationAborted() {
        if (!this.abortRequested) {
            return false;
        }
        this.aborted = true;
        LOGGER.info("{}================================================== Simulation aborted under request at time {} ==================================================", (Object)System.lineSeparator(), (Object)this.clock);
        return true;
    }

    private void notifyEndOfSimulationToEntities() {
        this.entityList.stream().filter(CloudSimEntity::isAlive).forEach(e -> this.sendNow((SimEntity)e, CloudSimTag.SIMULATION_END));
        LOGGER.info("{}: Processing last events before simulation shutdown.", (Object)this.clockStr());
        while (this.runClockTickAndProcessFutureEvents(Double.MAX_VALUE)) {
        }
    }

    private void printSimulationFinished() {
        Object msg2;
        String msg1 = "Simulation finished at time %.2f".formatted(this.clock);
        String extra = this.future.isEmpty() ? "" : ", before completing,";
        Object object = msg2 = this.isTimeToTerminateSimulationUnderRequest() ? extra + " in reason of an explicit request to terminate() or terminateAt()" : "";
        if (this.terminationTime > 0.0 && this.clock > this.lastCloudletProcessingUpdate + TimeUtil.minutesToSeconds(60.0)) {
            LOGGER.warn("Your simulation termination time was set to {}. Current time is {} but the last time a Cloudlet has processed was {} ago. If you think your simulation is taking to long to finish, maybe it's because you set a too long termination time and new events aren't arriving so far.", new Object[]{TimeUtil.secondsToStr(this.terminationTime), TimeUtil.secondsToStr(this.clock), TimeUtil.secondsToStr(this.clock - this.lastCloudletProcessingUpdate)});
        }
        LOGGER.info("{}================== {}{} =================={}", new Object[]{System.lineSeparator(), msg1, msg2, System.lineSeparator()});
    }

    @Override
    public boolean isTimeToTerminateSimulationUnderRequest() {
        return this.isTerminationTimeSet() && this.clock >= this.terminationTime;
    }

    @Override
    public boolean terminate() {
        if (this.running) {
            this.running = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean terminateAt(double time) {
        if (time <= this.clock) {
            return false;
        }
        this.terminationTime = time;
        return true;
    }

    @Override
    public double clock() {
        return this.clock;
    }

    @Override
    public String clockStr() {
        return "%.2f".formatted(this.clock);
    }

    @Override
    public double clockInMinutes() {
        return this.clock() / 60.0;
    }

    @Override
    public double clockInHours() {
        return this.clock() / 3600.0;
    }

    protected double setClock(double newTime) {
        double oldTime = this.clock;
        this.clock = newTime;
        return oldTime;
    }

    @Override
    public int getNumEntities() {
        return this.entityList.size();
    }

    @Override
    public List<SimEntity> getEntityList() {
        return Collections.unmodifiableList(this.entityList);
    }

    @Override
    public void addEntity(@NonNull CloudSimEntity entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (this.running) {
            CloudSimEvent evt = new CloudSimEvent(SimEvent.Type.CREATE, 0.0, entity, SimEntity.NULL, CloudSimTag.NONE, entity);
            this.future.addEvent(evt);
        }
        if (entity.getId() == -1L) {
            entity.setId(this.entityList.size());
            this.entityList.add(entity);
        }
    }

    protected void removeFinishedEntity(CloudSimEntity entity) {
        if (entity.isAlive()) {
            String msg = "Alive entity %s cannot be removed from the simulation entity list.";
            throw new IllegalStateException("Alive entity %s cannot be removed from the simulation entity list.".formatted(entity));
        }
        this.entityList.remove(entity);
    }

    private boolean runClockTickAndProcessFutureEvents(double until) {
        this.executeRunnableEntities(until);
        if (this.future.isEmpty()) {
            return false;
        }
        SimEvent first = this.future.first();
        if (first.getTime() <= until) {
            this.processFutureEventsHappeningAtSameTimeOfTheFirstOne(first);
            return true;
        }
        return false;
    }

    private boolean isToWaitClockToReachTerminationTime() {
        if (!this.isTerminationTimeSet()) {
            return false;
        }
        double increment = this.minDatacentersSchedulingInterval();
        String info = increment == this.minTimeBetweenEvents ? "using getMinTimeBetweenEvents() since a Datacenter schedulingInterval was not set" : "Datacenter.getSchedulingInterval()";
        LOGGER.info("{}: Simulation: Waiting more events or the clock to reach {} (the termination time set). Checking new events in {} seconds ({})", new Object[]{this.clockStr(), this.terminationTime, increment, info});
        this.setClock(this.clock + increment);
        return true;
    }

    private double minDatacentersSchedulingInterval() {
        return this.cis.getDatacenterList().stream().mapToDouble(Datacenter::getSchedulingInterval).filter(interval -> interval > 0.0).min().orElse(this.minTimeBetweenEvents);
    }

    private void processFutureEventsHappeningAtSameTimeOfTheFirstOne(SimEvent firstEvent) {
        SimEvent evt;
        this.processEvent(firstEvent);
        this.future.remove(firstEvent);
        while (!this.future.isEmpty() && (evt = this.future.first()).getTime() == firstEvent.getTime()) {
            this.processEvent(evt);
            this.future.remove(evt);
        }
    }

    private void executeRunnableEntities(double until) {
        for (int i = 0; i < this.entityList.size(); ++i) {
            CloudSimEntity ent = this.entityList.get(i);
            if (ent.getState() != SimEntity.State.RUNNABLE) continue;
            ent.run(until);
        }
    }

    private void sendNow(SimEntity dest, CloudSimTag tag) {
        this.sendNow(this.cis, dest, tag, null);
    }

    @Override
    public void sendNow(SimEntity src, SimEntity dest, CloudSimTag tag, Object data) {
        this.send(src, dest, 0.0, tag, data);
    }

    @Override
    public void send(SimEntity src, SimEntity dest, double delay, CloudSimTag tag, Object data) {
        this.send(new CloudSimEvent(SimEvent.Type.SEND, delay, src, dest, tag, data));
    }

    @Override
    public void send(@NonNull SimEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt is marked non-null but is null");
        }
        if (evt.getPriority() < 0) {
            this.future.addEventFirst(evt);
        } else {
            this.future.addEvent(evt);
        }
    }

    @Override
    public void sendFirst(SimEntity src, SimEntity dest, double delay, CloudSimTag tag, Object data) {
        this.sendFirst(new CloudSimEvent(SimEvent.Type.SEND, delay, src, dest, tag, data));
    }

    @Override
    public void sendFirst(SimEvent evt) {
        this.future.addEventFirst(evt);
    }

    @Override
    public void wait(CloudSimEntity src, Predicate<SimEvent> predicate) {
        src.setState(SimEntity.State.WAITING);
        if (predicate != ANY_EVT) {
            this.waitPredicates.put(src, predicate);
        }
    }

    @Override
    public SimEvent select(SimEntity dest, Predicate<SimEvent> predicate) {
        SimEvent evt = this.findFirstDeferred(dest, predicate);
        if (evt != SimEvent.NULL) {
            this.deferred.remove(evt);
        }
        return evt;
    }

    @Override
    public SimEvent findFirstDeferred(SimEntity dest, Predicate<SimEvent> predicate) {
        return this.filterEventsToDestinationEntity(this.deferred, predicate, dest).findFirst().orElse(SimEvent.NULL);
    }

    private Stream<SimEvent> filterEventsToDestinationEntity(EventQueue queue, Predicate<SimEvent> predicate, SimEntity dest) {
        return this.filterEvents(queue, predicate.and(evt -> evt.getDestination() == dest));
    }

    @Override
    public SimEvent cancel(SimEntity src, Predicate<SimEvent> predicate) {
        SimEvent canceled = this.future.stream().filter(this.isEventSourceEqualsTo(predicate, src)).findFirst().orElse(SimEvent.NULL);
        this.future.remove(canceled);
        return canceled;
    }

    @Override
    public boolean cancelAll(SimEntity src, Predicate<SimEvent> predicate) {
        int previousSize = this.future.size();
        this.future.removeIf(this.isEventSourceEqualsTo(predicate, src));
        return previousSize < this.future.size();
    }

    private Predicate<SimEvent> isEventSourceEqualsTo(Predicate<SimEvent> predicate, SimEntity src) {
        return predicate.and(evt -> evt.getSource().equals(src));
    }

    private Stream<SimEvent> filterEvents(EventQueue queue, Predicate<SimEvent> predicate) {
        return queue.stream().filter(predicate);
    }

    protected void processEvent(SimEvent evt) {
        if (evt.getTime() < this.clock) {
            String msg = "Past event detected. Event time: %.2f Simulation clock: %.2f";
            throw new IllegalArgumentException("Past event detected. Event time: %.2f Simulation clock: %.2f".formatted(evt.getTime(), this.clock));
        }
        this.setClock(evt.getTime());
        this.processEventByType(evt);
    }

    private void processEventByType(SimEvent evt) {
        switch (evt.getType()) {
            case NULL: {
                throw new IllegalArgumentException("Event has a null type.");
            }
            case CREATE: {
                this.processCreateEvent(evt);
                break;
            }
            case SEND: {
                this.processSendEvent(evt);
                break;
            }
            case HOLD_DONE: {
                this.processHoldEvent(evt);
            }
        }
    }

    private void processCreateEvent(SimEvent evt) {
        this.addEntityDynamically((SimEntity)evt.getData());
    }

    private void addEntityDynamically(@NonNull SimEntity entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        LOGGER.trace("Adding: {}", (Object)entity.getName());
        entity.start();
    }

    private void processHoldEvent(SimEvent evt) {
        if (evt.getSource() == SimEntity.NULL) {
            throw new IllegalArgumentException("Null entity holding.");
        }
        evt.getSource().setState(SimEntity.State.RUNNABLE);
    }

    private void processSendEvent(SimEvent evt) {
        if (evt.getDestination() == SimEntity.NULL) {
            throw new IllegalArgumentException("Attempt to send to a null entity detected.");
        }
        CloudSimEntity destEnt = (CloudSimEntity)evt.getDestination();
        if (destEnt.getState() != SimEntity.State.WAITING) {
            this.deferred.addEvent(evt);
            return;
        }
        Predicate<SimEvent> eventPredicate = this.waitPredicates.get(destEnt);
        if (eventPredicate == null || eventPredicate.test(evt)) {
            destEnt.setEventBuffer(new CloudSimEvent(evt));
            destEnt.setState(SimEntity.State.RUNNABLE);
            this.waitPredicates.remove(destEnt);
            return;
        }
        this.deferred.addEvent(evt);
    }

    private void startEntitiesIfNotRunning() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.entityList.forEach(SimEntity::start);
        LOGGER.info("Entities started.");
    }

    @Override
    public boolean pause() {
        return this.pause(this.clock);
    }

    @Override
    public boolean pause(double time) {
        if (time < this.clock) {
            return false;
        }
        this.pauseAt = time;
        LOGGER.info("{}: Pausing simulation under request", (Object)this.clockStr());
        return true;
    }

    @Override
    public boolean resume() {
        boolean wasPaused = this.paused;
        this.paused = false;
        if (wasPaused) {
            LOGGER.info("{}: Resuming simulation under request", (Object)this.clockStr());
        }
        if (this.pauseAt <= this.clock) {
            this.pauseAt = -1.0;
        }
        return wasPaused;
    }

    @Override
    public void pauseEntity(SimEntity src, double delay) {
        CloudSimEvent evt = new CloudSimEvent(SimEvent.Type.HOLD_DONE, delay, src);
        this.addHoldingFutureEvent(src, evt);
    }

    private void addHoldingFutureEvent(SimEntity src, SimEvent evt) {
        this.future.addEvent(evt);
        src.setState(SimEntity.State.HOLDING);
    }

    protected void holdEntity(SimEntity src, long delay) {
        CloudSimEvent evt = new CloudSimEvent(SimEvent.Type.HOLD_DONE, delay, src);
        this.addHoldingFutureEvent(src, evt);
    }

    private void checkIfSimulationPauseRequested() {
        if ((this.isThereFutureEvtsAndNextOneHappensAfterTimeToPause() || this.isNotThereNextFutureEvtsAndIsTimeToPause()) && this.doPause()) {
            this.waitsForSimulationToBeResumedIfPaused();
        }
    }

    protected boolean doPause() {
        if (this.running && this.isPauseRequested()) {
            this.paused = true;
            this.setClock(this.pauseAt);
            return true;
        }
        return false;
    }

    private boolean isPauseRequested() {
        return this.pauseAt > -1.0;
    }

    private void waitsForSimulationToBeResumedIfPaused() {
        while (this.paused) {
            Util.sleep(100L);
        }
        this.pauseAt = -1.0;
    }

    @Override
    public long getNumberOfFutureEvents(Predicate<SimEvent> predicate) {
        return this.future.stream().filter(predicate).count();
    }

    @Override
    public boolean isThereAnyFutureEvt(Predicate<SimEvent> predicate) {
        return this.future.stream().anyMatch(predicate);
    }

    private boolean isThereFutureEvtsAndNextOneHappensAfterTimeToPause() {
        return !this.future.isEmpty() && this.clock <= this.pauseAt && this.isNextFutureEventHappeningAfterTimeToPause();
    }

    private boolean isNotThereNextFutureEvtsAndIsTimeToPause() {
        return this.future.isEmpty() && this.clock >= this.pauseAt;
    }

    @Override
    public boolean isTerminationTimeSet() {
        return this.terminationTime > 0.0;
    }

    private boolean isNextFutureEventHappeningAfterTimeToPause() {
        return this.future.iterator().next().getTime() >= this.pauseAt;
    }

    @Override
    public void abort() {
        this.abortRequested = true;
        this.running = false;
    }

    public long getMaxEventsNumber() {
        return this.future.getMaxEventsNumber();
    }

    public long getGeneratedEventsNumber() {
        return this.future.getSerial();
    }

    public boolean noFutureEvents() {
        return this.future.isEmpty();
    }

    @Override
    @NonNull
    public NetworkTopology getNetworkTopology() {
        return this.networkTopology;
    }

    @Override
    public CloudSim setNetworkTopology(@NonNull NetworkTopology networkTopology) {
        if (networkTopology == null) {
            throw new NullPointerException("networkTopology is marked non-null but is null");
        }
        this.networkTopology = networkTopology;
        return this;
    }

    @Override
    public CloudInformationService getCis() {
        return this.cis;
    }

    @Override
    public Calendar getCalendar() {
        return this.calendar;
    }

    @Override
    public double getLastCloudletProcessingUpdate() {
        return this.lastCloudletProcessingUpdate;
    }

    @Override
    public CloudSim setLastCloudletProcessingUpdate(double lastCloudletProcessingUpdate) {
        this.lastCloudletProcessingUpdate = lastCloudletProcessingUpdate;
        return this;
    }

    @Override
    public double getMinTimeBetweenEvents() {
        return this.minTimeBetweenEvents;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean isAbortRequested() {
        return this.abortRequested;
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }
}

