/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.core;

import lombok.NonNull;
import org.cloudsimplus.brokers.DatacenterBroker;
import org.cloudsimplus.core.CustomerEntity;
import org.cloudsimplus.core.Simulation;
import org.cloudsimplus.core.UniquelyIdentifiable;
import org.cloudsimplus.datacenters.Datacenter;
import org.cloudsimplus.util.MathUtil;

public abstract class CustomerEntityAbstract
implements CustomerEntity {
    private long id;
    @NonNull
    private DatacenterBroker broker;
    private double arrivedTime;
    private double creationTime = -1.0;
    private Datacenter lastTriedDatacenter = Datacenter.NULL;

    protected CustomerEntityAbstract() {
    }

    @Override
    public String getUid() {
        return UniquelyIdentifiable.getUid(this.broker.getId(), this.id);
    }

    @Override
    public void setArrivedTime(double time) {
        this.arrivedTime = MathUtil.nonNegative(time, "Arrived time");
    }

    public void setCreationTime() {
        this.setCreationTime(this.getSimulation().clock());
    }

    public void setCreationTime(double time) {
        this.creationTime = MathUtil.nonNegative(time, "Creation time");
    }

    @Override
    public double getWaitTime() {
        return this.creationTime < 0.0 ? this.getSimulation().clock() - this.arrivedTime : this.creationTime - this.arrivedTime;
    }

    @Override
    public Simulation getSimulation() {
        return this.broker.getSimulation();
    }

    @Override
    public final long getId() {
        return this.id;
    }

    @Override
    @NonNull
    public final DatacenterBroker getBroker() {
        return this.broker;
    }

    @Override
    public final double getArrivedTime() {
        return this.arrivedTime;
    }

    @Override
    public final double getCreationTime() {
        return this.creationTime;
    }

    @Override
    public final Datacenter getLastTriedDatacenter() {
        return this.lastTriedDatacenter;
    }

    @Override
    public final CustomerEntityAbstract setId(long id) {
        this.id = id;
        return this;
    }

    @Override
    public final CustomerEntityAbstract setBroker(@NonNull DatacenterBroker broker) {
        if (broker == null) {
            throw new NullPointerException("broker is marked non-null but is null");
        }
        this.broker = broker;
        return this;
    }

    @Override
    public final CustomerEntityAbstract setLastTriedDatacenter(Datacenter lastTriedDatacenter) {
        this.lastTriedDatacenter = lastTriedDatacenter;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomerEntityAbstract)) {
            return false;
        }
        CustomerEntityAbstract other = (CustomerEntityAbstract)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        DatacenterBroker this$broker = this.getBroker();
        DatacenterBroker other$broker = other.getBroker();
        return !(this$broker == null ? other$broker != null : !this$broker.equals(other$broker));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomerEntityAbstract;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        DatacenterBroker $broker = this.getBroker();
        result = result * 59 + ($broker == null ? 43 : $broker.hashCode());
        return result;
    }
}

