/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.core;

import lombok.NonNull;
import org.cloudsimplus.core.CloudSimTag;
import org.cloudsimplus.core.Nameable;
import org.cloudsimplus.core.Simulation;
import org.cloudsimplus.core.events.SimEvent;

public interface SimEntity
extends Nameable,
Runnable,
Comparable<SimEntity> {
    public static final SimEntity NULL = comparable -> 0;

    public double getStartTime();

    public double getShutdownTime();

    public State getState();

    public SimEntity setState(@NonNull State var1);

    public boolean isStarted();

    public boolean isAlive();

    public boolean isFinished();

    public Simulation getSimulation();

    public void processEvent(SimEvent var1);

    public boolean schedule(SimEvent var1);

    default public boolean schedule(CloudSimTag tag) {
        return this.schedule(0.0, tag);
    }

    public boolean schedule(double var1, CloudSimTag var3, Object var4);

    public boolean schedule(double var1, CloudSimTag var3);

    public boolean schedule(SimEntity var1, double var2, CloudSimTag var4, Object var5);

    public boolean schedule(SimEntity var1, double var2, CloudSimTag var4);

    public boolean schedule(CloudSimTag var1, Object var2);

    @Override
    public void run();

    public boolean start();

    public void shutdown();

    public SimEntity setName(String var1) throws IllegalArgumentException;

    public static enum State {
        RUNNABLE,
        WAITING,
        HOLDING,
        FINISHED;

    }
}

