/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.core.events;

import java.util.Objects;
import lombok.NonNull;
import org.cloudsimplus.core.CloudSimTag;
import org.cloudsimplus.core.SimEntity;
import org.cloudsimplus.core.Simulation;
import org.cloudsimplus.core.events.SimEvent;
import org.cloudsimplus.listeners.EventInfo;
import org.cloudsimplus.listeners.EventListener;

public final class CloudSimEvent
implements SimEvent {
    @NonNull
    private Simulation simulation;
    private final SimEvent.Type type;
    private final double time;
    private double endWaitingTime;
    @NonNull
    private SimEntity source;
    @NonNull
    private SimEntity destination;
    private final CloudSimTag tag;
    private final Object data;
    private long serial = -1L;

    public CloudSimEvent(double delay, SimEntity source, SimEntity destination, CloudSimTag tag, Object data) {
        this(SimEvent.Type.SEND, delay, source, destination, tag, data);
    }

    public CloudSimEvent(double delay, SimEntity destination, CloudSimTag tag) {
        this(delay, destination, tag, null);
    }

    public CloudSimEvent(SimEntity destination, CloudSimTag tag, Object data) {
        this(0.0, destination, tag, data);
    }

    public CloudSimEvent(double delay, SimEntity destination, CloudSimTag tag, Object data) {
        this(SimEvent.Type.SEND, delay, destination, destination, tag, data);
    }

    public CloudSimEvent(SimEntity destination, CloudSimTag tag) {
        this(SimEvent.Type.SEND, 0.0, destination, destination, tag, null);
    }

    public CloudSimEvent(SimEvent.Type type, double delay, SimEntity source) {
        this(type, delay, source, SimEntity.NULL, CloudSimTag.NONE, null);
    }

    public CloudSimEvent(SimEvent source) {
        this(source.getType(), source.getTime(), source.getSource(), source.getDestination(), source.getTag(), source.getData());
    }

    public CloudSimEvent(SimEvent.Type type, double delay, SimEntity source, SimEntity destination, CloudSimTag tag, Object data) {
        if (delay < 0.0) {
            throw new IllegalArgumentException("Delay can't be negative.");
        }
        this.type = type;
        this.setSource(source);
        this.setDestination(destination);
        this.setSimulation(source.getSimulation());
        this.time = this.simulation.clock() + delay;
        this.tag = tag;
        this.data = data;
    }

    @Override
    public int compareTo(SimEvent that) {
        if (that == null || that == NULL) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        int res = Double.compare(this.time, that.getTime());
        if (res != 0) {
            return res;
        }
        res = this.tag.compareTo(that.getTag());
        if (res != 0) {
            return res;
        }
        return Long.compare(this.serial, that.getSerial());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CloudSimEvent that = (CloudSimEvent)obj;
        return Double.compare(that.getTime(), this.getTime()) == 0 && this.getTag() == that.getTag() && this.getSerial() == that.getSerial();
    }

    public int hashCode() {
        return Objects.hash(this.getTime(), this.getTag(), this.getSerial());
    }

    @Override
    public int getPriority() {
        return this.tag.priority();
    }

    public EventListener<? extends EventInfo> getListener() {
        return EventListener.NULL;
    }

    public String toString() {
        return "Event tag = " + this.tag + " source = " + this.source.getName() + " target = " + this.destination.getName() + " time = " + this.time;
    }

    @Override
    @NonNull
    public final Simulation getSimulation() {
        return this.simulation;
    }

    @Override
    public final SimEvent.Type getType() {
        return this.type;
    }

    @Override
    public final double getTime() {
        return this.time;
    }

    @Override
    public final double getEndWaitingTime() {
        return this.endWaitingTime;
    }

    @Override
    @NonNull
    public final SimEntity getSource() {
        return this.source;
    }

    @Override
    @NonNull
    public final SimEntity getDestination() {
        return this.destination;
    }

    @Override
    public final CloudSimTag getTag() {
        return this.tag;
    }

    @Override
    public final Object getData() {
        return this.data;
    }

    @Override
    public final long getSerial() {
        return this.serial;
    }

    @Override
    public final CloudSimEvent setSimulation(@NonNull Simulation simulation) {
        if (simulation == null) {
            throw new NullPointerException("simulation is marked non-null but is null");
        }
        this.simulation = simulation;
        return this;
    }

    @Override
    public final CloudSimEvent setSource(@NonNull SimEntity source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        this.source = source;
        return this;
    }

    @Override
    public final CloudSimEvent setDestination(@NonNull SimEntity destination) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        this.destination = destination;
        return this;
    }

    @Override
    public final CloudSimEvent setSerial(long serial) {
        this.serial = serial;
        return this;
    }
}

