/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.datacenters;

import java.util.List;
import java.util.stream.Stream;
import org.cloudsimplus.allocationpolicies.VmAllocationPolicy;
import org.cloudsimplus.core.SimEntity;
import org.cloudsimplus.core.Sizeable;
import org.cloudsimplus.datacenters.DatacenterCharacteristics;
import org.cloudsimplus.datacenters.DatacenterNull;
import org.cloudsimplus.datacenters.TimeZoned;
import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.listeners.DatacenterVmMigrationEventInfo;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.listeners.HostEventInfo;
import org.cloudsimplus.power.PowerAware;
import org.cloudsimplus.power.models.PowerModelDatacenter;
import org.cloudsimplus.resources.DatacenterStorage;
import org.cloudsimplus.vms.Vm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Datacenter
extends SimEntity,
PowerAware<PowerModelDatacenter>,
TimeZoned,
Sizeable {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)Datacenter.class.getSimpleName());
    public static final Datacenter NULL = new DatacenterNull();
    public static final double DEF_BW_PERCENT_FOR_MIGRATION = 0.5;

    public void requestVmMigration(Vm var1, Host var2);

    public void requestVmMigration(Vm var1);

    public <T extends Host> List<T> getHostList();

    public Stream<? extends Host> getActiveHostStream();

    public Host getHost(int var1);

    public long getActiveHostsNumber();

    @Override
    public long size();

    public Host getHostById(long var1);

    public <T extends Host> Datacenter addHostList(List<T> var1);

    public <T extends Host> Datacenter addHost(T var1);

    public <T extends Host> Datacenter removeHost(T var1);

    public VmAllocationPolicy getVmAllocationPolicy();

    public double getSchedulingInterval();

    public Datacenter setSchedulingInterval(double var1);

    public DatacenterCharacteristics getCharacteristics();

    public Datacenter setCharacteristics(DatacenterCharacteristics var1);

    public DatacenterStorage getDatacenterStorage();

    public void setDatacenterStorage(DatacenterStorage var1);

    public double getBandwidthPercentForMigration();

    public void setBandwidthPercentForMigration(double var1);

    public Datacenter addOnHostAvailableListener(EventListener<HostEventInfo> var1);

    public Datacenter addOnVmMigrationFinishListener(EventListener<DatacenterVmMigrationEventInfo> var1);

    public boolean isMigrationsEnabled();

    public Datacenter enableMigrations();

    public Datacenter disableMigrations();

    public double getHostSearchRetryDelay();

    public Datacenter setHostSearchRetryDelay(double var1);
}

