/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.datacenters;

import lombok.NonNull;
import org.cloudsimplus.core.AbstractMachine;
import org.cloudsimplus.datacenters.Datacenter;
import org.cloudsimplus.datacenters.DatacenterCharacteristics;
import org.cloudsimplus.hosts.Host;

public class DatacenterCharacteristicsSimple
implements DatacenterCharacteristics {
    @NonNull
    private Datacenter datacenter = Datacenter.NULL;
    @NonNull
    private String architecture = "x86";
    @NonNull
    private String os = "Linux";
    @NonNull
    private String vmm = "Xen";
    private double costPerSecond;
    private double costPerMem;
    private double costPerStorage;
    private double costPerBw;

    DatacenterCharacteristicsSimple(Datacenter datacenter) {
        this(0.0, 0.0, 0.0, 0.0);
        this.setDatacenter(datacenter);
    }

    public DatacenterCharacteristicsSimple(double costPerSecond, double costPerMem, double costPerStorage) {
        this(costPerSecond, costPerMem, costPerStorage, 0.0);
    }

    public DatacenterCharacteristicsSimple(double costPerSecond, double costPerMem, double costPerStorage, double costPerBw) {
        this.setCostPerSecond(costPerSecond);
        this.setCostPerMem(costPerMem);
        this.setCostPerStorage(costPerStorage);
        this.setCostPerBw(costPerBw);
    }

    void setDatacenter(@NonNull Datacenter dc) {
        if (dc == null) {
            throw new NullPointerException("dc is marked non-null but is null");
        }
        if (!Datacenter.NULL.equals(this.datacenter) && !this.datacenter.equals(dc)) {
            throw new IllegalStateException("This characteristics object is already attached to another Datacenter.");
        }
        this.datacenter = dc;
    }

    @Override
    public double getMips() {
        return this.datacenter.getHostList().stream().mapToDouble(Host::getTotalMipsCapacity).sum();
    }

    @Override
    public int getPesNumber() {
        return (int)this.datacenter.getHostList().stream().mapToLong(AbstractMachine::getPesNumber).sum();
    }

    @Override
    public long getNumberOfFailedHosts() {
        return this.datacenter.getHostList().stream().filter(Host::isFailed).count();
    }

    @Override
    public boolean isWorking() {
        return this.getNumberOfFailedHosts() == 0L;
    }

    @Override
    public long getId() {
        return this.datacenter.getId();
    }

    @Override
    @NonNull
    public final Datacenter getDatacenter() {
        return this.datacenter;
    }

    @Override
    @NonNull
    public final String getArchitecture() {
        return this.architecture;
    }

    @Override
    @NonNull
    public final String getOs() {
        return this.os;
    }

    @Override
    @NonNull
    public final String getVmm() {
        return this.vmm;
    }

    @Override
    public final double getCostPerSecond() {
        return this.costPerSecond;
    }

    @Override
    public final double getCostPerMem() {
        return this.costPerMem;
    }

    @Override
    public final double getCostPerStorage() {
        return this.costPerStorage;
    }

    @Override
    public final double getCostPerBw() {
        return this.costPerBw;
    }

    @Override
    public final DatacenterCharacteristicsSimple setArchitecture(@NonNull String architecture) {
        if (architecture == null) {
            throw new NullPointerException("architecture is marked non-null but is null");
        }
        this.architecture = architecture;
        return this;
    }

    @Override
    public final DatacenterCharacteristicsSimple setOs(@NonNull String os) {
        if (os == null) {
            throw new NullPointerException("os is marked non-null but is null");
        }
        this.os = os;
        return this;
    }

    @Override
    public final DatacenterCharacteristicsSimple setVmm(@NonNull String vmm) {
        if (vmm == null) {
            throw new NullPointerException("vmm is marked non-null but is null");
        }
        this.vmm = vmm;
        return this;
    }

    @Override
    public final DatacenterCharacteristicsSimple setCostPerSecond(double costPerSecond) {
        this.costPerSecond = costPerSecond;
        return this;
    }

    @Override
    public final DatacenterCharacteristicsSimple setCostPerMem(double costPerMem) {
        this.costPerMem = costPerMem;
        return this;
    }

    @Override
    public final DatacenterCharacteristicsSimple setCostPerStorage(double costPerStorage) {
        this.costPerStorage = costPerStorage;
        return this;
    }

    @Override
    public final DatacenterCharacteristicsSimple setCostPerBw(double costPerBw) {
        this.costPerBw = costPerBw;
        return this;
    }
}

