/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.datacenters;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.cloudsimplus.allocationpolicies.VmAllocationPolicy;
import org.cloudsimplus.allocationpolicies.VmAllocationPolicySimple;
import org.cloudsimplus.allocationpolicies.migration.VmAllocationPolicyMigration;
import org.cloudsimplus.autoscaling.VerticalVmScaling;
import org.cloudsimplus.cloudlets.Cloudlet;
import org.cloudsimplus.core.CloudSimEntity;
import org.cloudsimplus.core.CloudSimTag;
import org.cloudsimplus.core.CustomerEntityAbstract;
import org.cloudsimplus.core.Simulation;
import org.cloudsimplus.core.events.PredicateType;
import org.cloudsimplus.core.events.SimEvent;
import org.cloudsimplus.datacenters.Datacenter;
import org.cloudsimplus.datacenters.DatacenterCharacteristics;
import org.cloudsimplus.datacenters.DatacenterCharacteristicsSimple;
import org.cloudsimplus.faultinjection.HostFaultInjection;
import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.hosts.HostSimple;
import org.cloudsimplus.hosts.HostSuitability;
import org.cloudsimplus.listeners.DatacenterVmMigrationEventInfo;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.listeners.HostEventInfo;
import org.cloudsimplus.network.IcmpPacket;
import org.cloudsimplus.power.models.PowerModelDatacenter;
import org.cloudsimplus.power.models.PowerModelDatacenterSimple;
import org.cloudsimplus.resources.DatacenterStorage;
import org.cloudsimplus.resources.SanStorage;
import org.cloudsimplus.schedulers.cloudlet.CloudletScheduler;
import org.cloudsimplus.util.BytesConversion;
import org.cloudsimplus.util.InvalidEventDataTypeException;
import org.cloudsimplus.util.MathUtil;
import org.cloudsimplus.vms.Vm;
import org.cloudsimplus.vms.VmSimple;

public class DatacenterSimple
extends CloudSimEntity
implements Datacenter {
    private DatacenterCharacteristics characteristics;
    private double timeZone;
    private DatacenterStorage datacenterStorage;
    private List<? extends Host> hostList;
    private long activeHostsNumber;
    private PowerModelDatacenter powerModel = PowerModelDatacenter.NULL;
    private VmAllocationPolicy vmAllocationPolicy;
    private double hostSearchRetryDelay;
    private double lastUnderOrOverloadedDetection = -1.7976931348623157E308;
    private double schedulingInterval;
    private double lastProcessTime;
    private boolean migrationsEnabled;
    private double bandwidthPercentForMigration;
    private final List<EventListener<HostEventInfo>> onHostAvailableListeners;
    private final List<EventListener<DatacenterVmMigrationEventInfo>> onVmMigrationFinishListeners;
    private Map<Vm, Host> lastMigrationMap;

    public DatacenterSimple(Simulation simulation, List<? extends Host> hostList) {
        this(simulation, hostList, (VmAllocationPolicy)new VmAllocationPolicySimple(), new DatacenterStorage());
    }

    public DatacenterSimple(Simulation simulation, List<? extends Host> hostList, VmAllocationPolicy vmAllocationPolicy) {
        this(simulation, hostList, vmAllocationPolicy, new DatacenterStorage());
    }

    public DatacenterSimple(Simulation simulation, VmAllocationPolicy vmAllocationPolicy) {
        this(simulation, new ArrayList(), vmAllocationPolicy, new DatacenterStorage());
    }

    public DatacenterSimple(Simulation simulation, List<? extends Host> hostList, VmAllocationPolicy vmAllocationPolicy, List<SanStorage> storageList) {
        this(simulation, hostList, vmAllocationPolicy, new DatacenterStorage(storageList));
    }

    public DatacenterSimple(Simulation simulation, List<? extends Host> hostList, VmAllocationPolicy vmAllocationPolicy, DatacenterStorage storage) {
        super(simulation);
        this.setHostList(hostList);
        this.setLastProcessTime(0.0);
        this.setSchedulingInterval(0.0);
        this.setDatacenterStorage(storage);
        this.setPowerModel(new PowerModelDatacenterSimple(this));
        this.onHostAvailableListeners = new ArrayList<EventListener<HostEventInfo>>();
        this.onVmMigrationFinishListeners = new ArrayList<EventListener<DatacenterVmMigrationEventInfo>>();
        this.characteristics = new DatacenterCharacteristicsSimple(this);
        this.bandwidthPercentForMigration = 0.5;
        this.migrationsEnabled = true;
        this.hostSearchRetryDelay = -1.0;
        this.lastMigrationMap = Collections.emptyMap();
        this.setVmAllocationPolicy(vmAllocationPolicy);
    }

    private void setHostList(List<? extends Host> hostList) {
        this.hostList = Objects.requireNonNull(hostList);
        this.setupHosts();
    }

    private void setupHosts() {
        long lastHostId = this.getLastHostId();
        for (Host host : this.hostList) {
            lastHostId = this.setupHost(host, lastHostId);
        }
    }

    private long getLastHostId() {
        return this.hostList.isEmpty() ? -1L : this.hostList.get(this.hostList.size() - 1).getId();
    }

    protected long setupHost(Host host, long nextId) {
        nextId = Math.max(nextId, -1L);
        if (host.getId() < 0L) {
            host.setId(++nextId);
        }
        host.setSimulation(this.getSimulation());
        host.setDatacenter(this);
        host.setActive(((HostSimple)host).isActivateOnDatacenterStartup());
        return nextId;
    }

    @Override
    public void processEvent(SimEvent evt) {
        if (this.processCloudletEvents(evt) || this.processVmEvents(evt) || this.processNetworkEvents(evt) || this.processHostEvents(evt)) {
            return;
        }
        LOGGER.trace("{}: {}: Unknown event {} received.", new Object[]{this.getSimulation().clockStr(), this, evt.getTag()});
    }

    private boolean processHostEvents(SimEvent evt) {
        if (evt.getTag() == CloudSimTag.HOST_ADD) {
            this.processHostAdditionRequest(evt);
            return true;
        }
        if (evt.getTag() == CloudSimTag.HOST_REMOVE) {
            this.processHostRemovalRequest(evt);
            return true;
        }
        if (evt.getTag() == CloudSimTag.HOST_POWER_ON || evt.getTag() == CloudSimTag.HOST_POWER_OFF) {
            HostSimple host = (HostSimple)evt.getData();
            host.processActivation(evt.getTag() == CloudSimTag.HOST_POWER_ON);
        }
        return false;
    }

    private void processHostAdditionRequest(SimEvent evt) {
        this.getHostFromHostEvent(evt).ifPresent(host -> {
            this.addHost(host);
            LOGGER.info("{}: {}: Host {} added to {} during simulation runtime", new Object[]{this.getSimulation().clockStr(), this.getClass().getSimpleName(), host.getId(), this});
            this.notifyOnHostAvailableListeners(host);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processHostRemovalRequest(SimEvent srcEvt) {
        long hostId = (Long)srcEvt.getData();
        Host host = this.getHostById(hostId);
        if (Host.NULL.equals(host)) {
            LOGGER.warn("{}: {}: Host {} was not found to be removed from {}.", new Object[]{this.getSimulation().clockStr(), this.getClass().getSimpleName(), hostId, this});
            return;
        }
        HostFaultInjection fault = new HostFaultInjection(this);
        try {
            LOGGER.error("{}: {}: Host {} removed from {} due to injected failure.", new Object[]{this.getSimulation().clockStr(), this.getClass().getSimpleName(), host.getId(), this});
            fault.generateHostFault(host);
        }
        finally {
            fault.shutdown();
        }
        this.getSimulation().cancelAll(this.getSimulation().getCis(), evt -> MathUtil.same(evt.getTime(), srcEvt.getTime()) && evt.getTag() == CloudSimTag.HOST_REMOVE && ((Long)evt.getData()).longValue() == host.getId());
    }

    private Optional<Host> getHostFromHostEvent(SimEvent evt) {
        Optional<Host> optional;
        Object object = evt.getData();
        if (object instanceof Host) {
            Host h = (Host)object;
            optional = Optional.of(h);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    private boolean processNetworkEvents(SimEvent evt) {
        if (evt.getTag() == CloudSimTag.ICMP_PKT_SUBMIT) {
            this.processPingRequest(evt);
            return true;
        }
        return false;
    }

    private boolean processVmEvents(SimEvent evt) {
        return switch (evt.getTag()) {
            case CloudSimTag.VM_CREATE_ACK -> this.processVmCreate(evt);
            case CloudSimTag.VM_VERTICAL_SCALING -> this.requestVmVerticalScaling(evt);
            case CloudSimTag.VM_DESTROY -> this.processVmDestroy(evt, false);
            case CloudSimTag.VM_DESTROY_ACK -> this.processVmDestroy(evt, true);
            case CloudSimTag.VM_MIGRATE -> this.finishVmMigration(evt, false);
            case CloudSimTag.VM_MIGRATE_ACK -> this.finishVmMigration(evt, true);
            case CloudSimTag.VM_UPDATE_CLOUDLET_PROCESSING -> {
                if (this.updateCloudletProcessing() != Double.MAX_VALUE) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private boolean requestVmVerticalScaling(SimEvent evt) {
        Object object = evt.getData();
        if (object instanceof VerticalVmScaling) {
            VerticalVmScaling scaling = (VerticalVmScaling)object;
            return this.vmAllocationPolicy.scaleVmVertically(scaling);
        }
        throw new InvalidEventDataTypeException(evt, "VM_VERTICAL_SCALING", "VerticalVmScaling");
    }

    private boolean processCloudletEvents(SimEvent evt) {
        return switch (evt.getTag()) {
            case CloudSimTag.CLOUDLET_SUBMIT -> this.processCloudletSubmit(evt, false);
            case CloudSimTag.CLOUDLET_SUBMIT_ACK -> this.processCloudletSubmit(evt, true);
            case CloudSimTag.CLOUDLET_CANCEL -> this.processCloudlet(evt, CloudSimTag.CLOUDLET_CANCEL);
            case CloudSimTag.CLOUDLET_PAUSE -> this.processCloudlet(evt, CloudSimTag.CLOUDLET_PAUSE);
            case CloudSimTag.CLOUDLET_PAUSE_ACK -> this.processCloudlet(evt, CloudSimTag.CLOUDLET_PAUSE_ACK);
            case CloudSimTag.CLOUDLET_RESUME -> this.processCloudlet(evt, CloudSimTag.CLOUDLET_RESUME);
            case CloudSimTag.CLOUDLET_RESUME_ACK -> this.processCloudlet(evt, CloudSimTag.CLOUDLET_RESUME_ACK);
            default -> false;
        };
    }

    protected void processPingRequest(SimEvent evt) {
        Object object = evt.getData();
        if (object instanceof IcmpPacket) {
            IcmpPacket pkt = (IcmpPacket)object;
            pkt.setTag(CloudSimTag.ICMP_PKT_RETURN);
            pkt.setDestination(pkt.getSource());
            this.sendNow(pkt.getSource(), CloudSimTag.ICMP_PKT_RETURN, pkt);
        }
        throw new InvalidEventDataTypeException(evt, "ICMP_PKT_SUBMIT", IcmpPacket.class.getName());
    }

    protected boolean processCloudlet(SimEvent evt, CloudSimTag tag) {
        Object object = evt.getData();
        if (object instanceof Cloudlet) {
            Cloudlet cloudlet = (Cloudlet)object;
            return switch (tag) {
                case CloudSimTag.CLOUDLET_CANCEL -> this.processCloudletCancel(cloudlet);
                case CloudSimTag.CLOUDLET_PAUSE -> this.processCloudletPause(cloudlet, false);
                case CloudSimTag.CLOUDLET_PAUSE_ACK -> this.processCloudletPause(cloudlet, true);
                case CloudSimTag.CLOUDLET_RESUME -> this.processCloudletResume(cloudlet, false);
                case CloudSimTag.CLOUDLET_RESUME_ACK -> this.processCloudletResume(cloudlet, true);
                default -> {
                    LOGGER.trace("{}: Unable to handle a request from {} with event tag = {}", new Object[]{this, evt.getSource().getName(), evt.getTag()});
                    yield false;
                }
            };
        }
        throw new InvalidEventDataTypeException(evt, "CLOUDLET Tags", Cloudlet.class.getName());
    }

    protected boolean processCloudletSubmit(SimEvent evt, boolean ack) {
        Object object = evt.getData();
        if (object instanceof Cloudlet) {
            Cloudlet cloudlet = (Cloudlet)object;
            if (cloudlet.isFinished()) {
                this.notifyBrokerAboutAlreadyFinishedCloudlet(cloudlet, ack);
                return false;
            }
            this.submitCloudletToVm(cloudlet, ack);
            return true;
        }
        throw new InvalidEventDataTypeException(evt, "CLOUDLET_SUBMIT Tags", Cloudlet.class.getName());
    }

    private void submitCloudletToVm(Cloudlet cloudlet, boolean ack) {
        double fileTransferTime = this.getDatacenterStorage().predictFileTransferTime(cloudlet.getRequiredFiles());
        CloudletScheduler scheduler = cloudlet.getVm().getCloudletScheduler();
        double estimatedFinishTime = scheduler.cloudletSubmit(cloudlet, fileTransferTime);
        if (estimatedFinishTime > 0.0 && !Double.isInfinite(estimatedFinishTime)) {
            this.send(this, this.getCloudletProcessingUpdateInterval(estimatedFinishTime), CloudSimTag.VM_UPDATE_CLOUDLET_PROCESSING);
        }
        ((CustomerEntityAbstract)((Object)cloudlet)).setCreationTime();
        this.sendCloudletSubmitAckToBroker(cloudlet, ack);
    }

    protected double getCloudletProcessingUpdateInterval(double nextFinishingCloudletTime) {
        if (this.schedulingInterval == 0.0) {
            return nextFinishingCloudletTime;
        }
        double time = Math.floor(this.clock());
        double mod = time % this.schedulingInterval;
        double delay = mod == 0.0 ? this.schedulingInterval : time - mod + this.schedulingInterval - time;
        return Math.min(nextFinishingCloudletTime, delay);
    }

    private double clock() {
        return this.getSimulation().clock();
    }

    protected boolean processCloudletResume(Cloudlet cloudlet, boolean ack) {
        double estimatedFinishTime = cloudlet.getVm().getCloudletScheduler().cloudletResume(cloudlet);
        if (estimatedFinishTime > 0.0 && estimatedFinishTime > this.clock()) {
            this.schedule(this, this.getCloudletProcessingUpdateInterval(estimatedFinishTime), CloudSimTag.VM_UPDATE_CLOUDLET_PROCESSING);
        }
        this.sendAck(ack, cloudlet, CloudSimTag.CLOUDLET_RESUME_ACK);
        return true;
    }

    private void sendAck(boolean ack, Cloudlet cloudlet, CloudSimTag tag) {
        if (ack) {
            this.sendNow(cloudlet.getBroker(), tag, cloudlet);
        }
    }

    protected boolean processCloudletPause(Cloudlet cloudlet, boolean ack) {
        cloudlet.getVm().getCloudletScheduler().cloudletPause(cloudlet);
        this.sendAck(ack, cloudlet, CloudSimTag.CLOUDLET_PAUSE_ACK);
        return true;
    }

    protected boolean processCloudletCancel(Cloudlet cloudlet) {
        cloudlet.getVm().getCloudletScheduler().cloudletCancel(cloudlet);
        this.sendNow(cloudlet.getBroker(), CloudSimTag.CLOUDLET_CANCEL, cloudlet);
        return true;
    }

    private boolean processVmCreate(SimEvent evt) {
        Object object = evt.getData();
        if (object instanceof Vm) {
            Vm vm = (Vm)object;
            boolean hostAllocatedForVm = this.vmAllocationPolicy.allocateHostForVm(vm).fully();
            if (hostAllocatedForVm) {
                vm.updateProcessing(vm.getHost().getVmScheduler().getAllocatedMips(vm));
            }
            this.send(vm.getBroker(), this.getSimulation().getMinTimeBetweenEvents(), CloudSimTag.VM_CREATE_ACK, vm);
            return hostAllocatedForVm;
        }
        throw new InvalidEventDataTypeException(evt, "VM_CREATE Tags", Vm.class.getName());
    }

    protected boolean processVmDestroy(SimEvent evt, boolean ack) {
        Object object = evt.getData();
        if (object instanceof Vm) {
            Vm vm = (Vm)object;
            this.vmAllocationPolicy.deallocateHostForVm(vm);
            if (ack) {
                this.sendNow(vm.getBroker(), CloudSimTag.VM_DESTROY_ACK, vm);
            }
            vm.getBroker().requestShutdownWhenIdle();
            if (this.getSimulation().isAborted() || this.getSimulation().isAbortRequested()) {
                return true;
            }
            String warningMsg = this.generateNotFinishedCloudletsWarning(vm);
            String msg = "%s: %s: %s destroyed on %s. %s".formatted(this.getSimulation().clockStr(), this.getClass().getSimpleName(), vm, vm.getHost(), warningMsg);
            if (warningMsg.isEmpty() || this.getSimulation().isTerminationTimeSet()) {
                LOGGER.info(msg);
            } else {
                LOGGER.warn(msg);
            }
            return true;
        }
        throw new InvalidEventDataTypeException(evt, "VM_DESTROY Tags", Vm.class.getName());
    }

    private String generateNotFinishedCloudletsWarning(Vm vm) {
        int cloudletsNoFinished = vm.getCloudletScheduler().getCloudletList().size();
        if (cloudletsNoFinished == 0) {
            return "";
        }
        String options = "Some events may have been missed. You can try:\n(a) decreasing CloudSim's minTimeBetweenEvents and/or Datacenter's schedulingInterval attribute;\n(b) increasing broker's Vm destruction delay for idle VMs if you set it to zero;\n(c) defining Cloudlets with smaller length (your Datacenter's scheduling interval may be smaller than the time to finish some Cloudlets).\n";
        return "It had a total of %d cloudlets (running + waiting). %s".formatted(cloudletsNoFinished, "Some events may have been missed. You can try:\n(a) decreasing CloudSim's minTimeBetweenEvents and/or Datacenter's schedulingInterval attribute;\n(b) increasing broker's Vm destruction delay for idle VMs if you set it to zero;\n(c) defining Cloudlets with smaller length (your Datacenter's scheduling interval may be smaller than the time to finish some Cloudlets).\n");
    }

    protected boolean finishVmMigration(SimEvent evt, boolean ack) {
        SimEvent event;
        if (!(evt.getData() instanceof Map.Entry)) {
            throw new InvalidEventDataTypeException(evt, "VM_MIGRATE", "Map.Entry<Vm, Host>");
        }
        Map.Entry entry = (Map.Entry)evt.getData();
        Vm vm = (Vm)entry.getKey();
        Host sourceHost = vm.getHost();
        Host targetHost = (Host)entry.getValue();
        this.updateHostsProcessing();
        this.vmAllocationPolicy.deallocateHostForVm(vm);
        targetHost.removeMigratingInVm(vm);
        HostSuitability suitability = this.vmAllocationPolicy.allocateHostForVm(vm, targetHost);
        if (suitability.fully()) {
            ((VmSimple)vm).updateMigrationFinishListeners(targetHost);
            vm.getBroker().getVmExecList().add(vm);
            if (ack) {
                this.sendNow(evt.getSource(), CloudSimTag.VM_CREATE_ACK, vm);
            }
        }
        if ((event = this.getSimulation().findFirstDeferred(this, new PredicateType(CloudSimTag.VM_MIGRATE))) == null || event.getTime() > this.clock()) {
            this.updateHostsProcessing();
        }
        if (suitability.fully()) {
            LOGGER.info("{}: Migration of {} from {} to {} is completed.", new Object[]{this.getSimulation().clockStr(), vm, sourceHost, targetHost});
        } else {
            LOGGER.error("{}: {}: Allocation of {} to the destination {} failed due to {}!", new Object[]{this.getSimulation().clockStr(), this, vm, targetHost, suitability});
        }
        this.onVmMigrationFinishListeners.forEach(listener -> listener.update(DatacenterVmMigrationEventInfo.of(listener, vm, suitability)));
        return true;
    }

    private void notifyBrokerAboutAlreadyFinishedCloudlet(Cloudlet cloudlet, boolean ack) {
        LOGGER.warn("{}: {} owned by {} is already completed/finished. It won't be executed again.", new Object[]{this.getName(), cloudlet, cloudlet.getBroker()});
        this.sendCloudletSubmitAckToBroker(cloudlet, ack);
        this.sendNow(cloudlet.getBroker(), CloudSimTag.CLOUDLET_RETURN, cloudlet);
    }

    private void sendCloudletSubmitAckToBroker(Cloudlet cloudlet, boolean ack) {
        if (ack) {
            this.sendNow(cloudlet.getBroker(), CloudSimTag.CLOUDLET_SUBMIT_ACK, cloudlet);
        }
    }

    protected double updateHostsProcessing() {
        double nextSimulationDelay = Double.MAX_VALUE;
        for (Host host : this.getHostList()) {
            double delay = host.updateProcessing(this.clock());
            nextSimulationDelay = Math.min(delay, nextSimulationDelay);
        }
        double minTimeBetweenEvents = this.getSimulation().getMinTimeBetweenEvents() + 0.01;
        nextSimulationDelay = nextSimulationDelay == 0.0 ? nextSimulationDelay : Math.max(nextSimulationDelay, minTimeBetweenEvents);
        return nextSimulationDelay;
    }

    protected double updateCloudletProcessing() {
        if (!this.isTimeToUpdateCloudletsProcessing()) {
            return Double.MAX_VALUE;
        }
        double nextSimulationDelay = this.updateHostsProcessing();
        if (nextSimulationDelay != Double.MAX_VALUE) {
            nextSimulationDelay = this.getCloudletProcessingUpdateInterval(nextSimulationDelay);
            this.schedule(nextSimulationDelay, CloudSimTag.VM_UPDATE_CLOUDLET_PROCESSING);
        }
        this.setLastProcessTime(this.clock());
        this.checkIfVmMigrationsAreNeeded();
        return nextSimulationDelay;
    }

    private boolean isTimeToUpdateCloudletsProcessing() {
        return this.clock() < 0.111 || this.clock() >= this.lastProcessTime + this.getSimulation().getMinTimeBetweenEvents();
    }

    private void checkIfVmMigrationsAreNeeded() {
        if (!this.isTimeToSearchForSuitableHosts()) {
            return;
        }
        this.lastMigrationMap = this.vmAllocationPolicy.getOptimizedAllocationMap(this.getVmList());
        for (Map.Entry<Vm, Host> entry : this.lastMigrationMap.entrySet()) {
            this.requestVmMigration(entry.getKey(), entry.getValue());
        }
        if (this.areThereUnderOrOverloadedHostsAndMigrationIsSupported()) {
            this.lastUnderOrOverloadedDetection = this.clock();
        }
    }

    private boolean isTimeToSearchForSuitableHosts() {
        double elapsedSecs = this.clock() - this.lastUnderOrOverloadedDetection;
        return this.isMigrationsEnabled() && elapsedSecs >= this.hostSearchRetryDelay;
    }

    private boolean areThereUnderOrOverloadedHostsAndMigrationIsSupported() {
        VmAllocationPolicy vmAllocationPolicy = this.vmAllocationPolicy;
        if (vmAllocationPolicy instanceof VmAllocationPolicyMigration) {
            VmAllocationPolicyMigration migrationPolicy = (VmAllocationPolicyMigration)vmAllocationPolicy;
            return migrationPolicy.isUnderOrOverloaded();
        }
        return false;
    }

    @Override
    public void requestVmMigration(Vm sourceVm) {
        this.requestVmMigration(sourceVm, Host.NULL);
    }

    @Override
    public void requestVmMigration(Vm sourceVm, Host targetHost) {
        if (Host.NULL.equals(targetHost)) {
            targetHost = this.vmAllocationPolicy.findHostForVm(sourceVm).orElse(Host.NULL);
        }
        if (Host.NULL.equals(targetHost)) {
            LOGGER.warn("{}: {}: No suitable host found for {} in {}", new Object[]{sourceVm.getSimulation().clockStr(), this.getClass().getSimpleName(), sourceVm, this});
            return;
        }
        Host sourceHost = sourceVm.getHost();
        double delay = this.timeToMigrateVm(sourceVm, targetHost);
        String msg1 = Host.NULL.equals(sourceHost) ? "%s to %s".formatted(sourceVm, targetHost) : "%s from %s to %s".formatted(sourceVm, sourceHost, targetHost);
        String currentTime = this.getSimulation().clockStr();
        String fmt = "It's expected to finish in %.2f seconds, considering the %.0f%% of bandwidth allowed for migration and the VM RAM size.";
        String msg2 = "It's expected to finish in %.2f seconds, considering the %.0f%% of bandwidth allowed for migration and the VM RAM size.".formatted(delay, this.getBandwidthPercentForMigration() * 100.0);
        LOGGER.info("{}: {}: Migration of {} is started. {}", new Object[]{currentTime, this.getName(), msg1, msg2});
        if (targetHost.addMigratingInVm(sourceVm)) {
            sourceHost.addVmMigratingOut(sourceVm);
            this.send(this, delay, CloudSimTag.VM_MIGRATE, new AbstractMap.SimpleEntry<Vm, Host>(sourceVm, targetHost));
        }
    }

    private double timeToMigrateVm(Vm vm, Host targetHost) {
        return (double)vm.getRam().getCapacity() / BytesConversion.bitsToBytes((double)targetHost.getBw().getCapacity() * this.getBandwidthPercentForMigration());
    }

    @Override
    public void shutdown() {
        super.shutdown();
        LOGGER.info("{}: {} is shutting down...", (Object)this.getSimulation().clockStr(), (Object)this.getName());
    }

    @Override
    protected void startInternal() {
        LOGGER.info("{}: {} is starting...", (Object)this.getSimulation().clockStr(), (Object)this.getName());
        this.hostList.stream().filter(Predicate.not(Host::isActive)).map(host -> (HostSimple)host).forEach(host -> host.setActive(host.isActivateOnDatacenterStartup()));
        this.sendNow(this.getSimulation().getCis(), CloudSimTag.DC_REGISTRATION_REQUEST, this);
    }

    @Override
    public <T extends Host> List<T> getHostList() {
        return Collections.unmodifiableList(this.hostList);
    }

    @Override
    public Stream<? extends Host> getActiveHostStream() {
        return this.hostList.stream().filter(Host::isActive);
    }

    public final Datacenter setVmAllocationPolicy(VmAllocationPolicy vmAllocationPolicy) {
        Objects.requireNonNull(vmAllocationPolicy);
        if (vmAllocationPolicy.getDatacenter() != null && vmAllocationPolicy.getDatacenter() != Datacenter.NULL && !this.equals(vmAllocationPolicy.getDatacenter())) {
            throw new IllegalStateException("The given VmAllocationPolicy is already used by another Datacenter.");
        }
        vmAllocationPolicy.setDatacenter(this);
        this.vmAllocationPolicy = vmAllocationPolicy;
        return this;
    }

    @Override
    public final void setDatacenterStorage(DatacenterStorage datacenterStorage) {
        datacenterStorage.setDatacenter(this);
        this.datacenterStorage = datacenterStorage;
    }

    private <T extends Vm> List<T> getVmList() {
        return Collections.unmodifiableList(this.getHostList().stream().map(Host::getVmList).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    @Override
    public final Datacenter setSchedulingInterval(double schedulingInterval) {
        this.schedulingInterval = Math.max(schedulingInterval, 0.0);
        return this;
    }

    @Override
    public final Datacenter setTimeZone(double timeZone) {
        this.timeZone = this.validateTimeZone(timeZone);
        return this;
    }

    @Override
    public Host getHost(int index) {
        if (index >= 0 && index < this.getHostList().size()) {
            return (Host)this.getHostList().get(index);
        }
        return Host.NULL;
    }

    public void updateActiveHostsNumber(Host host) {
        this.activeHostsNumber += host.isActive() ? 1L : -1L;
    }

    @Override
    public long size() {
        return this.hostList.size();
    }

    @Override
    public Host getHostById(long id) {
        return this.hostList.stream().filter(host -> host.getId() == id).findFirst().map(host -> host).orElse(Host.NULL);
    }

    @Override
    public <T extends Host> Datacenter addHostList(List<T> hostList) {
        Objects.requireNonNull(hostList);
        hostList.forEach(this::addHost);
        return this;
    }

    @Override
    public <T extends Host> Datacenter addHost(T host) {
        if (this.vmAllocationPolicy == null || this.vmAllocationPolicy == VmAllocationPolicy.NULL) {
            throw new IllegalStateException("A VmAllocationPolicy must be set before adding a new Host to the Datacenter.");
        }
        this.setupHost(host, this.getLastHostId());
        this.hostList.add(host);
        return this;
    }

    private <T extends Host> void notifyOnHostAvailableListeners(T host) {
        this.onHostAvailableListeners.forEach(listener -> listener.update(HostEventInfo.of(listener, host, this.clock())));
    }

    @Override
    public <T extends Host> Datacenter removeHost(T host) {
        this.hostList.remove(host);
        return this;
    }

    public String toString() {
        return "Datacenter %d".formatted(this.getId());
    }

    @Override
    public void setBandwidthPercentForMigration(double bandwidthPercentForMigration) {
        if (bandwidthPercentForMigration <= 0.0) {
            throw new IllegalArgumentException("The bandwidth migration percentage must be greater than 0.");
        }
        if (bandwidthPercentForMigration > 1.0) {
            throw new IllegalArgumentException("The bandwidth migration percentage must be lower or equal to 1.");
        }
        this.bandwidthPercentForMigration = bandwidthPercentForMigration;
    }

    @Override
    public Datacenter addOnHostAvailableListener(EventListener<HostEventInfo> listener) {
        this.onHostAvailableListeners.add(Objects.requireNonNull(listener));
        return this;
    }

    @Override
    public Datacenter addOnVmMigrationFinishListener(EventListener<DatacenterVmMigrationEventInfo> listener) {
        this.onVmMigrationFinishListeners.add(Objects.requireNonNull(listener));
        return this;
    }

    @Override
    public boolean isMigrationsEnabled() {
        return this.migrationsEnabled && this.vmAllocationPolicy.isVmMigrationSupported();
    }

    @Override
    public final Datacenter enableMigrations() {
        if (!this.vmAllocationPolicy.isVmMigrationSupported()) {
            LOGGER.warn("{}: {}: It was requested to enable VM migrations but the {} doesn't support that.", new Object[]{this.getSimulation().clockStr(), this.getName(), this.vmAllocationPolicy.getClass().getSimpleName()});
            return this;
        }
        this.migrationsEnabled = true;
        return this;
    }

    @Override
    public final Datacenter disableMigrations() {
        this.migrationsEnabled = false;
        return this;
    }

    public final Datacenter setPowerModel(PowerModelDatacenter powerModel) {
        Objects.requireNonNull(powerModel, "powerModel cannot be null. You could provide a " + PowerModelDatacenter.class.getSimpleName() + ".NULL instead");
        if (powerModel.getDatacenter() != null && powerModel.getDatacenter() != Datacenter.NULL && !this.equals(powerModel.getDatacenter())) {
            throw new IllegalStateException("The given PowerModel is already assigned to another Datacenter. Each Datacenter must have its own PowerModel instance.");
        }
        this.powerModel = powerModel;
        return null;
    }

    @Override
    public Datacenter setHostSearchRetryDelay(double delay) {
        if (delay == 0.0) {
            throw new IllegalArgumentException("hostSearchRetryDelay cannot be 0. Set a positive value to define an actual delay or a negative value to indicate a new Host search must be tried as soon as possible.");
        }
        this.hostSearchRetryDelay = delay;
        return this;
    }

    @Override
    public Datacenter setCharacteristics(@NonNull DatacenterCharacteristics c) {
        if (c == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        ((DatacenterCharacteristicsSimple)c).setDatacenter(this);
        this.characteristics = c;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatacenterSimple)) {
            return false;
        }
        DatacenterSimple other = (DatacenterSimple)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DatacenterCharacteristics this$characteristics = this.getCharacteristics();
        DatacenterCharacteristics other$characteristics = other.getCharacteristics();
        return !(this$characteristics == null ? other$characteristics != null : !this$characteristics.equals(other$characteristics));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DatacenterSimple;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DatacenterCharacteristics $characteristics = this.getCharacteristics();
        result = result * 59 + ($characteristics == null ? 43 : $characteristics.hashCode());
        return result;
    }

    @Override
    public final DatacenterCharacteristics getCharacteristics() {
        return this.characteristics;
    }

    @Override
    public final double getTimeZone() {
        return this.timeZone;
    }

    @Override
    public final DatacenterStorage getDatacenterStorage() {
        return this.datacenterStorage;
    }

    @Override
    public final long getActiveHostsNumber() {
        return this.activeHostsNumber;
    }

    @Override
    public final PowerModelDatacenter getPowerModel() {
        return this.powerModel;
    }

    @Override
    public final VmAllocationPolicy getVmAllocationPolicy() {
        return this.vmAllocationPolicy;
    }

    @Override
    public final double getHostSearchRetryDelay() {
        return this.hostSearchRetryDelay;
    }

    @Override
    public final double getSchedulingInterval() {
        return this.schedulingInterval;
    }

    protected final double getLastProcessTime() {
        return this.lastProcessTime;
    }

    protected final DatacenterSimple setLastProcessTime(double lastProcessTime) {
        this.lastProcessTime = lastProcessTime;
        return this;
    }

    @Override
    public final double getBandwidthPercentForMigration() {
        return this.bandwidthPercentForMigration;
    }
}

