/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.datacenters;

import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.iterators.ReverseListIterator;
import org.cloudsimplus.datacenters.Datacenter;
import org.cloudsimplus.util.TimeUtil;
import org.cloudsimplus.vms.Vm;

public interface TimeZoned {
    public static final int MIN_TIME_ZONE_OFFSET = -12;
    public static final int MAX_TIME_ZONE_OFFSET = 14;

    public double getTimeZone();

    public TimeZoned setTimeZone(double var1);

    default public double validateTimeZone(double timeZone) {
        if (timeZone < -12.0 || timeZone > 14.0) {
            String msg = "Timezone offset must be between [%d and %d].";
            throw new IllegalArgumentException("Timezone offset must be between [%d and %d].".formatted(-12, 14));
        }
        return timeZone;
    }

    public static Datacenter closestDatacenter(Vm vm, List<Datacenter> datacenters) {
        Datacenter currentDc;
        if (Objects.requireNonNull(datacenters).isEmpty()) {
            throw new IllegalArgumentException("The list of Datacenters is empty.");
        }
        if (datacenters.size() == 1) {
            return datacenters.get(0);
        }
        ReverseListIterator iterator = vm.getTimeZone() <= 0.0 ? datacenters.listIterator() : new ReverseListIterator(datacenters);
        Datacenter previousDc = currentDc = Datacenter.NULL;
        while (iterator.hasNext()) {
            currentDc = (Datacenter)iterator.next();
            if (vm.distance(currentDc) > vm.distance(previousDc)) {
                return previousDc;
            }
            previousDc = currentDc;
        }
        return currentDc;
    }

    default public double distance(TimeZoned other) {
        return Math.abs(other.getTimeZone() - this.getTimeZone());
    }

    public static String format(double timeZone) {
        double decimals = timeZone - (double)((int)timeZone);
        String timezoneStr = decimals == 0.0 ? "GMT%+.0f".formatted(timeZone) : "GMT%+d:%2.0f".formatted((int)timeZone, TimeUtil.hoursToMinutes(decimals));
        return "%-8s".formatted(timezoneStr);
    }
}

