/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.datacenters.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.cloudsimplus.allocationpolicies.VmAllocationPolicy;
import org.cloudsimplus.core.Simulation;
import org.cloudsimplus.datacenters.DatacenterSimple;
import org.cloudsimplus.hosts.network.NetworkHost;
import org.cloudsimplus.network.switches.Switch;

public class NetworkDatacenter
extends DatacenterSimple {
    private final List<Switch> switchMap = new ArrayList<Switch>();

    public NetworkDatacenter(Simulation simulation, List<? extends NetworkHost> hostList, VmAllocationPolicy vmAllocationPolicy) {
        this(simulation, hostList);
        this.setVmAllocationPolicy(vmAllocationPolicy);
    }

    public NetworkDatacenter(Simulation simulation, List<? extends NetworkHost> hostList) {
        super(simulation, hostList);
    }

    public List<Switch> getEdgeSwitch() {
        return this.switchMap.stream().filter(swt -> swt.getLevel() == 2).collect(Collectors.toList());
    }

    public void addSwitch(Switch swt) {
        this.switchMap.add(swt);
    }

    public List<Switch> getSwitchMap() {
        return Collections.unmodifiableList(this.switchMap);
    }

    public List<NetworkHost> getHostList() {
        return super.getHostList();
    }
}

