/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.distributions;

import org.apache.commons.math3.distribution.LogNormalDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.cloudsimplus.distributions.ContinuousDistribution;
import org.cloudsimplus.distributions.StatisticalDistribution;
import org.cloudsimplus.util.MathUtil;

public class LogNormalDistr
extends LogNormalDistribution
implements ContinuousDistribution {
    private static final long serialVersionUID = -1023800693849880578L;
    private boolean applyAntitheticVariates;
    private long seed;

    public LogNormalDistr(double shape, double scale) {
        this(shape, scale, StatisticalDistribution.defaultSeed());
    }

    public LogNormalDistr(double shape, double scale, long seed) {
        this(shape, scale, seed, StatisticalDistribution.newDefaultGen(seed));
    }

    public LogNormalDistr(double shape, double scale, long seed, RandomGenerator rng) {
        super(rng, scale, shape);
        this.seed = MathUtil.nonNegative(seed, "Seed");
    }

    public void reseedRandomGenerator(long seed) {
        super.reseedRandomGenerator(seed);
        this.seed = seed;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public boolean isApplyAntitheticVariates() {
        return this.applyAntitheticVariates;
    }

    @Override
    public LogNormalDistr setApplyAntitheticVariates(boolean applyAntitheticVariates) {
        this.applyAntitheticVariates = applyAntitheticVariates;
        return this;
    }

    @Override
    public double originalSample() {
        return super.sample();
    }
}

