/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.distributions;

import org.apache.commons.math3.random.RandomGenerator;
import org.cloudsimplus.distributions.ContinuousDistribution;
import org.cloudsimplus.distributions.ParetoDistr;
import org.cloudsimplus.distributions.StatisticalDistribution;
import org.cloudsimplus.util.MathUtil;

public class LomaxDistr
extends ParetoDistr
implements ContinuousDistribution {
    private static final long serialVersionUID = 8444069359429898420L;
    private long seed;
    private final double shift;

    public LomaxDistr(double shape, double location, double shift) {
        this(shape, location, shift, StatisticalDistribution.defaultSeed());
    }

    public LomaxDistr(double shape, double location, double shift, long seed) {
        this(shape, location, shift, seed, StatisticalDistribution.newDefaultGen(seed));
    }

    public LomaxDistr(double shape, double location, double shift, long seed, RandomGenerator rng) {
        super(shape, location, seed, rng);
        if (shift > location) {
            throw new IllegalArgumentException("Shift must be smaller or equal than location");
        }
        this.seed = MathUtil.nonNegative(seed, "Seed");
        this.shift = shift;
    }

    @Override
    public double sample() {
        return super.sample() - this.shift;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public void reseedRandomGenerator(long seed) {
        super.reseedRandomGenerator(seed);
        this.seed = seed;
    }
}

