/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.distributions;

import org.apache.commons.math3.distribution.ParetoDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.cloudsimplus.distributions.ContinuousDistribution;
import org.cloudsimplus.distributions.StatisticalDistribution;
import org.cloudsimplus.util.MathUtil;

public class ParetoDistr
extends ParetoDistribution
implements ContinuousDistribution {
    private static final long serialVersionUID = 5395364227220680901L;
    private boolean applyAntitheticVariates;
    private long seed;

    public ParetoDistr(double shape, double location) {
        this(shape, location, StatisticalDistribution.defaultSeed());
    }

    public ParetoDistr(double shape, double location, long seed) {
        this(shape, location, seed, StatisticalDistribution.newDefaultGen(seed));
    }

    public ParetoDistr(double shape, double location, long seed, RandomGenerator rng) {
        super(rng, location, shape);
        this.seed = MathUtil.nonNegative(seed, "Seed");
    }

    public void reseedRandomGenerator(long seed) {
        super.reseedRandomGenerator(seed);
        this.seed = seed;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public boolean isApplyAntitheticVariates() {
        return this.applyAntitheticVariates;
    }

    @Override
    public ParetoDistr setApplyAntitheticVariates(boolean applyAntitheticVariates) {
        this.applyAntitheticVariates = applyAntitheticVariates;
        return this;
    }

    @Override
    public double originalSample() {
        return super.sample();
    }
}

