/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.distributions;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.cloudsimplus.distributions.DiscreteDistribution;
import org.cloudsimplus.distributions.StatisticalDistribution;
import org.cloudsimplus.distributions.UniformDistr;

public class PoissonDistr
implements DiscreteDistribution {
    private boolean applyAntitheticVariates;
    private final UniformDistr rand;
    private double lambda;
    private int k;

    public PoissonDistr(double lambda, long seed) {
        if (seed < 0L) {
            throw new IllegalArgumentException("Seed cannot be negative");
        }
        this.rand = new UniformDistr(seed);
        this.k = 1;
        this.setLambda(lambda);
    }

    public PoissonDistr(double lambda) {
        this(lambda, StatisticalDistribution.defaultSeed());
    }

    public double getLambda() {
        return this.lambda;
    }

    private void setLambda(double lambda) {
        this.lambda = lambda;
    }

    public double eventsArrivalProbability() {
        return Math.pow(this.getLambda(), this.k) * Math.exp(-this.getLambda()) / (double)CombinatoricsUtils.factorial((int)this.k);
    }

    public boolean eventsHappened() {
        return this.rand.sample() <= this.eventsArrivalProbability();
    }

    @Override
    public double sample() {
        return -Math.log(1.0 - this.rand.sample()) / this.getLambda();
    }

    @Override
    public long getSeed() {
        return this.rand.getSeed();
    }

    @Override
    public boolean isApplyAntitheticVariates() {
        return this.applyAntitheticVariates;
    }

    @Override
    public PoissonDistr setApplyAntitheticVariates(boolean applyAntitheticVariates) {
        this.applyAntitheticVariates = applyAntitheticVariates;
        return this;
    }

    @Override
    public double originalSample() {
        return this.rand.sample();
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public double getInterArrivalMeanTime() {
        return 1.0 / this.lambda;
    }

    public static void main(String[] args) {
        double MEAN_CUSTOMERS_ARRIVAL_MINUTE = 0.4;
        int SIMULATION_TIME_LENGTH = 25;
        boolean showCustomerArrivals = true;
        int NUMBER_OF_SIMULATIONS = 100;
        BiConsumer<PoissonDistr, Integer> printArrivals = (poisson, minute) -> System.out.printf("%d customers arrived at minute %d%n", poisson.getK(), minute);
        Function<PoissonDistr, Integer> runSimulation = poisson -> {
            int totalArrivedCustomers = IntStream.range(0, 25).filter(time -> poisson.eventsHappened()).peek(time -> printArrivals.accept((PoissonDistr)poisson, time)).map(time -> poisson.getK()).sum();
            System.out.printf("\t%d customers arrived in %d minutes%n", totalArrivedCustomers, 25);
            System.out.printf("\tArrival rate: %.2f customers per minute. Customers inter-arrival time: %.2f minutes in average%n", poisson.getLambda(), poisson.getInterArrivalMeanTime());
            return totalArrivedCustomers;
        };
        double customersInAllSimulations = 0.0;
        PoissonDistr poisson2 = null;
        long seed = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            poisson2 = new PoissonDistr(0.4, seed + (long)i);
            System.out.printf("Simulation number %d%n", i);
            customersInAllSimulations += (double)runSimulation.apply(poisson2).intValue();
        }
        double mean = customersInAllSimulations / 100.0;
        System.out.printf("%nArrived customers average after %d simulations: %.2f%n", 100, mean);
        System.out.printf("%.2f customers expected by each %d minutes of simulation with inter-arrival time of %.2f minutes%n", poisson2.getLambda() * 25.0, 25, poisson2.getInterArrivalMeanTime());
    }
}

