/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.distributions;

import org.apache.commons.lang3.Range;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.cloudsimplus.distributions.ContinuousDistribution;
import org.cloudsimplus.distributions.StatisticalDistribution;
import org.cloudsimplus.util.MathUtil;

public class UniformDistr
extends UniformRealDistribution
implements ContinuousDistribution {
    private static final long serialVersionUID = 3341651849752903428L;
    private boolean applyAntitheticVariates;
    private long seed;

    public UniformDistr() {
        this(0.0, 1.0);
    }

    public UniformDistr(long seed) {
        this(0.0, 1.0, seed);
    }

    public UniformDistr(long seed, RandomGenerator rng) {
        this(0.0, 1.0, seed, rng);
    }

    public UniformDistr(Range<Double> range) {
        this(range, StatisticalDistribution.defaultSeed());
    }

    public UniformDistr(Range<Double> range, long seed) {
        this((Double)range.getMinimum(), (Double)range.getMaximum() + 1.0, seed);
    }

    public UniformDistr(double minInclusive, double maxExclusive) {
        this(minInclusive, maxExclusive, StatisticalDistribution.defaultSeed());
    }

    public UniformDistr(double minInclusive, double maxExclusive, long seed) {
        this(minInclusive, maxExclusive, seed, StatisticalDistribution.newDefaultGen(seed));
    }

    public UniformDistr(double minInclusive, double maxExclusive, long seed, RandomGenerator rng) {
        super(rng, minInclusive, maxExclusive);
        this.seed = MathUtil.nonNegative(seed, "Seed");
        this.applyAntitheticVariates = false;
    }

    @Override
    public double sample() {
        return this.applyAntitheticVariates ? 1.0 - super.sample() : super.sample();
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public boolean isApplyAntitheticVariates() {
        return this.applyAntitheticVariates;
    }

    @Override
    public UniformDistr setApplyAntitheticVariates(boolean applyAntitheticVariates) {
        this.applyAntitheticVariates = applyAntitheticVariates;
        return this;
    }

    @Override
    public double originalSample() {
        return super.sample();
    }

    public void reseedRandomGenerator(long seed) {
        super.reseedRandomGenerator(seed);
        this.seed = seed;
    }
}

