/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.faultinjection;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import lombok.NonNull;
import org.cloudsimplus.cloudlets.Cloudlet;
import org.cloudsimplus.faultinjection.VmCloner;
import org.cloudsimplus.vms.Vm;

public class VmClonerSimple
implements VmCloner {
    @NonNull
    private UnaryOperator<Vm> vmClonerFunction;
    @NonNull
    private Function<Vm, List<Cloudlet>> cloudletsClonerFunction;
    private int maxClonesNumber = 1;
    private int clonedVmsNumber;

    public VmClonerSimple(UnaryOperator<Vm> vmClonerFunction, Function<Vm, List<Cloudlet>> cloudletsClonerFunction) {
        this.setVmClonerFunction((UnaryOperator)vmClonerFunction);
        this.setCloudletsClonerFunction((Function)cloudletsClonerFunction);
    }

    @Override
    public Map.Entry<Vm, List<Cloudlet>> clone(@NonNull Vm sourceVm) {
        if (sourceVm == null) {
            throw new NullPointerException("sourceVm is marked non-null but is null");
        }
        Vm clonedVm = (Vm)this.vmClonerFunction.apply(sourceVm);
        List<Cloudlet> clonedCloudletList = this.cloudletsClonerFunction.apply(sourceVm);
        if (clonedCloudletList.isEmpty()) {
            LOGGER.warn("{}: {}: There was no Cloudlet from {} in {} to clone.", new Object[]{sourceVm.getSimulation().clockStr(), this.getClass().getSimpleName(), sourceVm, sourceVm.getBroker()});
        }
        clonedCloudletList.forEach(cloudlet -> cloudlet.setVm(clonedVm));
        ++this.clonedVmsNumber;
        return new AbstractMap.SimpleEntry<Vm, List<Cloudlet>>(clonedVm, clonedCloudletList);
    }

    @Override
    public boolean isMaxClonesNumberReached() {
        return this.clonedVmsNumber >= this.maxClonesNumber;
    }

    @Override
    public final VmClonerSimple setVmClonerFunction(@NonNull UnaryOperator<Vm> vmClonerFunction) {
        if (vmClonerFunction == null) {
            throw new NullPointerException("vmClonerFunction is marked non-null but is null");
        }
        this.vmClonerFunction = vmClonerFunction;
        return this;
    }

    @Override
    public final VmClonerSimple setCloudletsClonerFunction(@NonNull Function<Vm, List<Cloudlet>> cloudletsClonerFunction) {
        if (cloudletsClonerFunction == null) {
            throw new NullPointerException("cloudletsClonerFunction is marked non-null but is null");
        }
        this.cloudletsClonerFunction = cloudletsClonerFunction;
        return this;
    }

    @Override
    public final int getMaxClonesNumber() {
        return this.maxClonesNumber;
    }

    @Override
    public final VmClonerSimple setMaxClonesNumber(int maxClonesNumber) {
        this.maxClonesNumber = maxClonesNumber;
        return this;
    }

    @Override
    public final int getClonedVmsNumber() {
        return this.clonedVmsNumber;
    }
}

