/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.heuristics;

import java.util.List;
import lombok.NonNull;
import org.cloudsimplus.cloudlets.Cloudlet;
import org.cloudsimplus.distributions.ContinuousDistribution;
import org.cloudsimplus.heuristics.CloudletToVmMappingHeuristic;
import org.cloudsimplus.heuristics.CloudletToVmMappingSolution;
import org.cloudsimplus.heuristics.SimulatedAnnealingAbstract;
import org.cloudsimplus.vms.Vm;

public class CloudletToVmMappingSimulatedAnnealing
extends SimulatedAnnealingAbstract<CloudletToVmMappingSolution>
implements CloudletToVmMappingHeuristic {
    private CloudletToVmMappingSolution initialSolution;
    @NonNull
    private List<Vm> vmList;
    @NonNull
    private List<Cloudlet> cloudletList;

    public CloudletToVmMappingSimulatedAnnealing(double initialTemperature, ContinuousDistribution random) {
        super(random, CloudletToVmMappingSolution.class);
        this.setCurrentTemperature(initialTemperature);
        this.initialSolution = new CloudletToVmMappingSolution(this);
    }

    private CloudletToVmMappingSolution generateRandomSolution() {
        CloudletToVmMappingSolution solution = new CloudletToVmMappingSolution(this);
        this.cloudletList.forEach(cloudlet -> solution.bindCloudletToVm((Cloudlet)cloudlet, this.getRandomVm()));
        return solution;
    }

    private boolean isReadToGenerateInitialSolution() {
        return !this.cloudletList.isEmpty() && !this.vmList.isEmpty();
    }

    private boolean isThereInitialSolution() {
        return !this.initialSolution.getResult().isEmpty();
    }

    @Override
    public CloudletToVmMappingSolution getInitialSolution() {
        if (!this.isThereInitialSolution() && this.isReadToGenerateInitialSolution()) {
            this.initialSolution = this.generateRandomSolution();
        }
        return this.initialSolution;
    }

    private Vm getRandomVm() {
        int idx = this.getRandomValue(this.vmList.size());
        return this.vmList.get(idx);
    }

    @Override
    public CloudletToVmMappingSolution createNeighbor(CloudletToVmMappingSolution source) {
        CloudletToVmMappingSolution clone = new CloudletToVmMappingSolution(source);
        clone.swapVmsOfTwoRandomSelectedMapEntries();
        return clone;
    }

    @Override
    @NonNull
    public final List<Vm> getVmList() {
        return this.vmList;
    }

    @Override
    public final CloudletToVmMappingSimulatedAnnealing setVmList(@NonNull List<Vm> vmList) {
        if (vmList == null) {
            throw new NullPointerException("vmList is marked non-null but is null");
        }
        this.vmList = vmList;
        return this;
    }

    @Override
    @NonNull
    public final List<Cloudlet> getCloudletList() {
        return this.cloudletList;
    }

    @Override
    public final CloudletToVmMappingSimulatedAnnealing setCloudletList(@NonNull List<Cloudlet> cloudletList) {
        if (cloudletList == null) {
            throw new NullPointerException("cloudletList is marked non-null but is null");
        }
        this.cloudletList = cloudletList;
        return this;
    }
}

