/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.heuristics;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import lombok.NonNull;
import org.cloudsimplus.distributions.ContinuousDistribution;
import org.cloudsimplus.heuristics.Heuristic;
import org.cloudsimplus.heuristics.HeuristicSolution;

public abstract class HeuristicAbstract<S extends HeuristicSolution<?>>
implements Heuristic<S> {
    private final Class<S> solutionClass;
    private final ContinuousDistribution random;
    private int searchesByIteration;
    private S bestSolutionSoFar;
    private S neighborSolution;
    private double solveTime;

    HeuristicAbstract(@NonNull ContinuousDistribution random, @NonNull Class<S> solutionClass) {
        if (random == null) {
            throw new NullPointerException("random is marked non-null but is null");
        }
        if (solutionClass == null) {
            throw new NullPointerException("solutionClass is marked non-null but is null");
        }
        this.random = random;
        this.solutionClass = solutionClass;
        this.searchesByIteration = 1;
        this.setBestSolutionSoFar(this.newSolutionInstance());
        this.setNeighborSolution(this.bestSolutionSoFar);
    }

    protected void setSolveTime(double solveTime) {
        this.solveTime = solveTime;
    }

    private S newSolutionInstance() {
        try {
            Constructor<S> constructor = this.solutionClass.getConstructor(Heuristic.class);
            return (S)((HeuristicSolution)constructor.newInstance(this));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected abstract void updateSystemState();

    @Override
    public int getRandomValue(int maxValue) {
        double uniform = this.getRandom().sample();
        return (int)(uniform >= 1.0 ? uniform % (double)maxValue : uniform * (double)maxValue);
    }

    @Override
    public S solve() {
        long startTime = System.currentTimeMillis();
        this.setBestSolutionSoFar(this.getInitialSolution());
        while (!this.isToStopSearch()) {
            this.searchSolutionInNeighborhood();
            this.updateSystemState();
        }
        this.setSolveTime((double)(System.currentTimeMillis() - startTime) / 1000.0);
        return this.bestSolutionSoFar;
    }

    private void searchSolutionInNeighborhood() {
        for (int i = 0; i < this.searchesByIteration; ++i) {
            this.setNeighborSolution(this.createNeighbor(this.bestSolutionSoFar));
            if (!(this.getAcceptanceProbability() > (double)this.getRandomValue(1))) continue;
            this.setBestSolutionSoFar(this.neighborSolution);
        }
    }

    protected final void setBestSolutionSoFar(S solution) {
        this.bestSolutionSoFar = solution;
    }

    protected final void setNeighborSolution(S solution) {
        this.neighborSolution = solution;
    }

    public final ContinuousDistribution getRandom() {
        return this.random;
    }

    @Override
    public final int getSearchesByIteration() {
        return this.searchesByIteration;
    }

    @Override
    public final S getBestSolutionSoFar() {
        return this.bestSolutionSoFar;
    }

    @Override
    public final S getNeighborSolution() {
        return this.neighborSolution;
    }

    @Override
    public final double getSolveTime() {
        return this.solveTime;
    }

    @Override
    public final HeuristicAbstract<S> setSearchesByIteration(int searchesByIteration) {
        this.searchesByIteration = searchesByIteration;
        return this;
    }
}

