/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.hosts;

import java.util.List;
import java.util.Set;
import org.cloudsimplus.core.Machine;
import org.cloudsimplus.core.ResourceStatsComputer;
import org.cloudsimplus.core.Simulation;
import org.cloudsimplus.datacenters.Datacenter;
import org.cloudsimplus.hosts.HostNull;
import org.cloudsimplus.hosts.HostStateHistoryEntry;
import org.cloudsimplus.hosts.HostSuitability;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.listeners.HostEventInfo;
import org.cloudsimplus.listeners.HostUpdatesVmsProcessingEventInfo;
import org.cloudsimplus.power.PowerAware;
import org.cloudsimplus.power.models.PowerModelHost;
import org.cloudsimplus.provisioners.ResourceProvisioner;
import org.cloudsimplus.resources.Pe;
import org.cloudsimplus.resources.ResourceManageable;
import org.cloudsimplus.schedulers.vm.VmScheduler;
import org.cloudsimplus.vms.HostResourceStats;
import org.cloudsimplus.vms.Vm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Host
extends Machine,
Comparable<Host>,
PowerAware<PowerModelHost>,
ResourceStatsComputer<HostResourceStats> {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)Host.class.getSimpleName());
    public static final double DEF_IDLE_SHUTDOWN_DEADLINE = -1.0;
    public static final Host NULL = new HostNull();

    public Datacenter getDatacenter();

    public void setDatacenter(Datacenter var1);

    public boolean isSuitableForVm(Vm var1);

    public HostSuitability getSuitabilityFor(Vm var1);

    public boolean isActive();

    public boolean hasEverStarted();

    public Host setActive(boolean var1);

    public <T extends Vm> Set<T> getVmsMigratingIn();

    public boolean hasMigratingVms();

    public boolean addMigratingInVm(Vm var1);

    public Set<Vm> getVmsMigratingOut();

    public boolean addVmMigratingOut(Vm var1);

    public boolean removeVmMigratingOut(Vm var1);

    public void reallocateMigratingInVms();

    @Override
    public double getTotalMipsCapacity();

    public double getTotalAvailableMips();

    public double getTotalAllocatedMips();

    public double getTotalAllocatedMipsForVm(Vm var1);

    public void removeMigratingInVm(Vm var1);

    public List<Pe> getPeList();

    public List<Pe> getWorkingPeList();

    public List<Pe> getBusyPeList();

    public List<Pe> getFreePeList();

    public int getFreePesNumber();

    public int getWorkingPesNumber();

    public int getBusyPesNumber();

    public double getBusyPesPercent();

    public double getBusyPesPercent(boolean var1);

    public int getFailedPesNumber();

    public long getAvailableStorage();

    public ResourceProvisioner getBwProvisioner();

    public Host setBwProvisioner(ResourceProvisioner var1);

    public ResourceProvisioner getRamProvisioner();

    public Host setRamProvisioner(ResourceProvisioner var1);

    public <T extends Vm> List<T> getVmList();

    public <T extends Vm> List<T> getVmCreatedList();

    public VmScheduler getVmScheduler();

    public Host setVmScheduler(VmScheduler var1);

    public double getFirstStartTime();

    public double getShutdownTime();

    public void setShutdownTime(double var1);

    public double getUpTime();

    public double getUpTimeHours();

    public double getTotalUpTime();

    public double getTotalUpTimeHours();

    public double getIdleShutdownDeadline();

    public Host setIdleShutdownDeadline(double var1);

    public boolean isFailed();

    public boolean setFailed(boolean var1);

    public double updateProcessing(double var1);

    public HostSuitability createVm(Vm var1);

    public void destroyVm(Vm var1);

    public HostSuitability createTemporaryVm(Vm var1);

    public void destroyTemporaryVm(Vm var1);

    public void destroyAllVms();

    public Host addOnStartupListener(EventListener<HostEventInfo> var1);

    public boolean removeOnStartupListener(EventListener<HostEventInfo> var1);

    public Host addOnShutdownListener(EventListener<HostEventInfo> var1);

    public boolean removeOnShutdownListener(EventListener<HostEventInfo> var1);

    public Host addOnUpdateProcessingListener(EventListener<HostUpdatesVmsProcessingEventInfo> var1);

    public boolean removeOnUpdateProcessingListener(EventListener<HostUpdatesVmsProcessingEventInfo> var1);

    public Host setSimulation(Simulation var1);

    public ResourceProvisioner getProvisioner(Class<? extends ResourceManageable> var1);

    public double getCpuPercentUtilization();

    public double getCpuPercentRequested();

    @Override
    public HostResourceStats getCpuUtilizationStats();

    @Override
    public void enableUtilizationStats();

    public double getCpuMipsUtilization();

    public long getBwUtilization();

    public long getRamUtilization();

    @Override
    public PowerModelHost getPowerModel();

    @Override
    public PowerAware<PowerModelHost> setPowerModel(PowerModelHost var1);

    public Host setStateHistoryEnabled(boolean var1);

    public boolean isStateHistoryEnabled();

    public List<HostStateHistoryEntry> getStateHistory();

    public List<Vm> getFinishedVms();

    public List<Vm> getMigratableVms();

    public boolean isLazySuitabilityEvaluation();

    public Host setLazySuitabilityEvaluation(boolean var1);
}

