/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.listeners;

import org.cloudsimplus.datacenters.Datacenter;
import org.cloudsimplus.listeners.DatacenterEventInfo;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.listeners.VmEventInfo;
import org.cloudsimplus.vms.Vm;

public interface VmDatacenterEventInfo
extends VmEventInfo,
DatacenterEventInfo {
    public static VmDatacenterEventInfo of(EventListener<VmDatacenterEventInfo> listener, Vm vm) {
        return VmDatacenterEventInfo.of(listener, vm, vm.getHost().getDatacenter());
    }

    public static VmDatacenterEventInfo of(final EventListener<VmDatacenterEventInfo> listener, final Vm vm, final Datacenter datacenter) {
        final double time = vm.getSimulation().clock();
        return new VmDatacenterEventInfo(){

            @Override
            public Datacenter getDatacenter() {
                return datacenter;
            }

            @Override
            public Vm getVm() {
                return vm;
            }

            @Override
            public double getTime() {
                return time;
            }

            public EventListener<VmDatacenterEventInfo> getListener() {
                return listener;
            }
        };
    }
}

