/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.network;

import org.cloudsimplus.network.FloydWarshall;
import org.cloudsimplus.network.topologies.TopologicalGraph;
import org.cloudsimplus.network.topologies.TopologicalLink;
import org.cloudsimplus.util.Util;

public class DelayMatrix {
    private static final double DELAY_NOT_SET = Double.MAX_VALUE;
    private double[][] mDelayMatrix;
    private int mTotalNodeNum;

    public DelayMatrix() {
        this.mDelayMatrix = new double[0][0];
    }

    public DelayMatrix(TopologicalGraph graph, boolean directed) {
        this.createDelayMatrix(graph, directed);
        this.calculateShortestPath();
    }

    public double getDelay(int srcID, int destID) {
        if (srcID > this.mTotalNodeNum || destID > this.mTotalNodeNum) {
            throw new ArrayIndexOutOfBoundsException("srcID or destID is higher than highest stored nodeID!");
        }
        return this.mDelayMatrix[srcID][destID];
    }

    private void createDelayMatrix(TopologicalGraph graph, boolean directed) {
        this.mTotalNodeNum = graph.getNumberOfNodes();
        this.mDelayMatrix = Util.newSquareMatrix(this.mTotalNodeNum, Double.MAX_VALUE);
        for (TopologicalLink edge : graph.getLinksList()) {
            this.mDelayMatrix[edge.getSrcNodeID()][edge.getDestNodeID()] = edge.getLinkDelay();
            if (directed) continue;
            this.mDelayMatrix[edge.getDestNodeID()][edge.getSrcNodeID()] = edge.getLinkDelay();
        }
    }

    private void calculateShortestPath() {
        FloydWarshall floyd = new FloydWarshall(this.mTotalNodeNum);
        this.mDelayMatrix = floyd.computeShortestPaths(this.mDelayMatrix);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(100);
        builder.append("DelayMatrix: %n".formatted(new Object[0]));
        for (int column = 0; column < this.mTotalNodeNum; ++column) {
            builder.append('\t').append(column);
        }
        for (int row = 0; row < this.mTotalNodeNum; ++row) {
            builder.append(System.lineSeparator()).append(row);
            for (int col = 0; col < this.mTotalNodeNum; ++col) {
                if (this.mDelayMatrix[row][col] == Double.MAX_VALUE) {
                    builder.append("\t-");
                    continue;
                }
                builder.append('\t').append(this.mDelayMatrix[row][col]);
            }
        }
        return builder.toString();
    }
}

