/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.network;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.cloudsimplus.util.MathUtil;

public class FloydWarshall {
    private final int numVertices;
    private final List<Integer> vertices;
    private final double[][] dkMinusOne;
    private final int[][] pk;
    private final int[][] pkMinusOne;

    public FloydWarshall(int numVertices) {
        this.numVertices = MathUtil.nonNegative(numVertices, "Number of vertices");
        this.vertices = IntStream.range(0, numVertices).boxed().collect(Collectors.toList());
        this.dkMinusOne = new double[numVertices][numVertices];
        this.pk = new int[numVertices][numVertices];
        this.pkMinusOne = new int[numVertices][numVertices];
    }

    public double[][] computeShortestPaths(double[][] originalDelayMatrix) {
        this.savePreviousDelays(originalDelayMatrix);
        return this.computeShortestPaths();
    }

    private double[][] computeShortestPaths() {
        double[][] dk = new double[this.numVertices][this.numVertices];
        for (int k : this.vertices) {
            this.computeShortestPathForSpecificNumberOfHops(dk, k);
        }
        return dk;
    }

    private void computeShortestPathForSpecificNumberOfHops(double[][] dk, int k) {
        for (int i2 : this.vertices) {
            this.computeShortestPathFromVertexToAllVertices(dk, k, i2);
        }
        this.updateMatrices((i, j) -> {
            this.dkMinusOne[i.intValue()][j.intValue()] = dk[i][j];
            this.pkMinusOne[i.intValue()][j.intValue()] = this.pk[i][j];
        });
    }

    private void updateMatrices(BiConsumer<Integer, Integer> updater) {
        for (int i : this.vertices) {
            for (int j : this.vertices) {
                updater.accept(i, j);
            }
        }
    }

    private void computeShortestPathFromVertexToAllVertices(double[][] dk, int k, int i) {
        for (int j : this.vertices) {
            this.pk[i][j] = -1;
            if (i == j) continue;
            if (this.dkMinusOne[i][j] <= this.dkMinusOne[i][k] + this.dkMinusOne[k][j]) {
                dk[i][j] = this.dkMinusOne[i][j];
                this.pk[i][j] = this.pkMinusOne[i][j];
                continue;
            }
            dk[i][j] = this.dkMinusOne[i][k] + this.dkMinusOne[k][j];
            this.pk[i][j] = this.pkMinusOne[k][j];
        }
    }

    private void savePreviousDelays(double[][] originalDelayMatrix) {
        for (int i : this.vertices) {
            for (int j : this.vertices) {
                this.dkMinusOne[i][j] = Double.MAX_VALUE;
                this.pkMinusOne[i][j] = -1;
                if (originalDelayMatrix[i][j] == 0.0) continue;
                this.dkMinusOne[i][j] = originalDelayMatrix[i][j];
                this.pkMinusOne[i][j] = i;
            }
        }
    }

    public int[][] getPk() {
        return (int[][])Arrays.copyOf(this.pk, this.pk.length);
    }

    public final int getNumVertices() {
        return this.numVertices;
    }
}

