/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.network.switches;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;
import org.cloudsimplus.core.CloudSimEntity;
import org.cloudsimplus.core.CloudSimPlus;
import org.cloudsimplus.core.CloudSimTag;
import org.cloudsimplus.core.events.PredicateType;
import org.cloudsimplus.core.events.SimEvent;
import org.cloudsimplus.datacenters.network.NetworkDatacenter;
import org.cloudsimplus.hosts.network.NetworkHost;
import org.cloudsimplus.network.HostPacket;
import org.cloudsimplus.network.switches.Switch;
import org.cloudsimplus.util.BytesConversion;
import org.cloudsimplus.util.MathUtil;
import org.cloudsimplus.vms.Vm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSwitch
extends CloudSimEntity
implements Switch {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AbstractSwitch.class.getSimpleName());
    @NonNull
    private NetworkDatacenter datacenter;
    private double uplinkBandwidth;
    private double downlinkBandwidth;
    private int ports;
    private double switchingDelay;
    private final List<Switch> uplinkSwitches;
    private final List<Switch> downlinkSwitches;
    private final Map<Switch, List<HostPacket>> uplinkSwitchPacketMap;
    private final Map<Switch, List<HostPacket>> downlinkSwitchPacketMap;
    private final Map<NetworkHost, List<HostPacket>> packetToHostMap = new HashMap<NetworkHost, List<HostPacket>>();

    public AbstractSwitch(CloudSimPlus simulation, NetworkDatacenter dc) {
        super(simulation);
        this.uplinkSwitchPacketMap = new HashMap<Switch, List<HostPacket>>();
        this.downlinkSwitchPacketMap = new HashMap<Switch, List<HostPacket>>();
        this.downlinkSwitches = new ArrayList<Switch>();
        this.uplinkSwitches = new ArrayList<Switch>();
        this.datacenter = Objects.requireNonNull(dc);
    }

    @Override
    protected void startInternal() {
        LOGGER.info("{} is starting...", (Object)this.getName());
        this.schedule(CloudSimTag.DC_LIST_REQUEST);
    }

    @Override
    public void processEvent(SimEvent evt) {
        switch (evt.getTag()) {
            case NETWORK_EVENT_UP: {
                this.processPacketUp(evt);
                break;
            }
            case NETWORK_EVENT_DOWN: {
                this.processPacketDown(evt);
                break;
            }
            case NETWORK_EVENT_SEND: {
                this.processPacketForward();
                break;
            }
            case NETWORK_EVENT_HOST: {
                this.processHostPacket(evt);
                break;
            }
            default: {
                LOGGER.trace("{}: {}: Unknown event {} received.", new Object[]{this.getSimulation().clockStr(), this, evt.getTag()});
            }
        }
    }

    protected void processHostPacket(SimEvent evt) {
        Object object = evt.getData();
        if (!(object instanceof HostPacket)) {
            throw new IllegalStateException("NETWORK_EVENT_HOST SimEvent data must be a HostPacket");
        }
        HostPacket pkt = (HostPacket)object;
        NetworkHost host = pkt.getDestination();
        host.addReceivedNetworkPacket(pkt);
    }

    protected void processPacketDown(SimEvent evt) {
        this.getSimulation().cancelAll(this, new PredicateType(CloudSimTag.NETWORK_EVENT_SEND));
        this.schedule(this, this.getSwitchingDelay(), CloudSimTag.NETWORK_EVENT_SEND);
    }

    protected NetworkHost getVmHost(Vm vm) {
        return (NetworkHost)vm.getHost();
    }

    protected void processPacketUp(SimEvent evt) {
        this.getSimulation().cancelAll(this, new PredicateType(CloudSimTag.NETWORK_EVENT_SEND));
        this.schedule(this, this.switchingDelay, CloudSimTag.NETWORK_EVENT_SEND);
    }

    private void processPacketForward() {
        this.forwardPacketsToDownlinkSwitches();
        this.forwardPacketsToUplinkSwitches();
        this.forwardPacketsToHosts();
    }

    private void forwardPacketsToDownlinkSwitches() {
        for (Switch targetSwitch : this.downlinkSwitchPacketMap.keySet()) {
            List<HostPacket> hostPktList = this.getDownlinkSwitchPacketList(targetSwitch);
            double bw = this.downlinkBandwidth;
            this.forwardPacketsToSwitch(targetSwitch, hostPktList, bw, CloudSimTag.NETWORK_EVENT_DOWN);
        }
    }

    private void forwardPacketsToUplinkSwitches() {
        for (Switch targetSwitch : this.uplinkSwitchPacketMap.keySet()) {
            List<HostPacket> hostPktList = this.getUplinkSwitchPacketList(targetSwitch);
            double bw = this.uplinkBandwidth;
            this.forwardPacketsToSwitch(targetSwitch, hostPktList, bw, CloudSimTag.NETWORK_EVENT_UP);
        }
    }

    private void forwardPacketsToSwitch(Switch destinationSwitch, List<HostPacket> packetList, double bandwidth, CloudSimTag tag) {
        for (HostPacket pkt : packetList) {
            double delay = this.packetTransferDelay(pkt, bandwidth, packetList.size());
            this.send(destinationSwitch, delay, tag, pkt);
        }
        packetList.clear();
    }

    private void forwardPacketsToHosts() {
        for (NetworkHost host : this.packetToHostMap.keySet()) {
            List<HostPacket> hostPktList = this.getHostPacketList(host);
            this.forwardPacketsToSwitch(this, hostPktList, this.downlinkBandwidth, CloudSimTag.NETWORK_EVENT_HOST);
        }
    }

    @Override
    public double downlinkTransferDelay(HostPacket packet, int simultaneousPackets) {
        return this.packetTransferDelay(packet, this.downlinkBandwidth, simultaneousPackets);
    }

    @Override
    public double uplinkTransferDelay(HostPacket packet, int simultaneousPackets) {
        return this.packetTransferDelay(packet, this.uplinkBandwidth, simultaneousPackets);
    }

    protected double packetTransferDelay(HostPacket netPkt, double bwCapacity, int simultaneousPackets) {
        return BytesConversion.bytesToMegaBits(netPkt.getSize()) / this.bandwidthByPacket(bwCapacity, simultaneousPackets);
    }

    protected double bandwidthByPacket(double bwCapacity, int simultaneousPackets) {
        return simultaneousPackets == 0 ? bwCapacity : bwCapacity / (double)simultaneousPackets;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        LOGGER.info("{} is shutting down...", (Object)this.getName());
    }

    @Override
    public final void setUplinkBandwidth(double uplinkBandwidth) {
        this.uplinkBandwidth = MathUtil.nonNegative(uplinkBandwidth, "uplinkBandwidth");
    }

    @Override
    public final void setDownlinkBandwidth(double downlinkBandwidth) {
        this.downlinkBandwidth = MathUtil.nonNegative(downlinkBandwidth, "downlinkBandwidth");
    }

    @Override
    public final void setPorts(int ports) {
        this.ports = MathUtil.nonNegative(ports, "ports");
    }

    @Override
    public final void setSwitchingDelay(double switchingDelay) {
        this.switchingDelay = MathUtil.nonNegative(switchingDelay, "switchingDelay");
    }

    protected List<HostPacket> getDownlinkSwitchPacketList(Switch downlinkSwitch) {
        return this.downlinkSwitchPacketMap.getOrDefault(downlinkSwitch, new ArrayList());
    }

    protected List<HostPacket> getUplinkSwitchPacketList(Switch uplinkSwitch) {
        return this.uplinkSwitchPacketMap.getOrDefault(uplinkSwitch, new ArrayList());
    }

    protected List<HostPacket> getHostPacketList(NetworkHost host) {
        return this.packetToHostMap.getOrDefault(host, new ArrayList());
    }

    protected void addPacketToSendToDownlinkSwitch(Switch downlinkSwitch, HostPacket packet) {
        this.computeMapValue(this.downlinkSwitchPacketMap, downlinkSwitch, packet);
    }

    protected void addPacketToBeSentToFirstUplinkSwitch(HostPacket netPkt) {
        Switch uplinkSw = this.getUplinkSwitches().get(0);
        this.addPacketToSendToUplinkSwitch(uplinkSw, netPkt);
    }

    protected void addPacketToSendToUplinkSwitch(Switch uplinkSwitch, HostPacket packet) {
        this.computeMapValue(this.uplinkSwitchPacketMap, uplinkSwitch, packet);
    }

    protected void addPacketToSendToHost(NetworkHost host, HostPacket packet) {
        this.computeMapValue(this.packetToHostMap, host, packet);
    }

    private <K, V> void computeMapValue(Map<K, List<V>> map, K key, V valueToAdd) {
        map.compute(key, (k, list) -> list == null ? new ArrayList() : list).add(valueToAdd);
    }

    @Override
    @NonNull
    public final NetworkDatacenter getDatacenter() {
        return this.datacenter;
    }

    @Override
    public final AbstractSwitch setDatacenter(@NonNull NetworkDatacenter datacenter) {
        if (datacenter == null) {
            throw new NullPointerException("datacenter is marked non-null but is null");
        }
        this.datacenter = datacenter;
        return this;
    }

    @Override
    public final double getUplinkBandwidth() {
        return this.uplinkBandwidth;
    }

    @Override
    public final double getDownlinkBandwidth() {
        return this.downlinkBandwidth;
    }

    @Override
    public final int getPorts() {
        return this.ports;
    }

    @Override
    public final double getSwitchingDelay() {
        return this.switchingDelay;
    }

    @Override
    public final List<Switch> getUplinkSwitches() {
        return this.uplinkSwitches;
    }

    @Override
    public final List<Switch> getDownlinkSwitches() {
        return this.downlinkSwitches;
    }
}

