/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.network.switches;

import java.util.List;
import java.util.Optional;
import org.cloudsimplus.core.CloudSimPlus;
import org.cloudsimplus.core.events.SimEvent;
import org.cloudsimplus.datacenters.network.NetworkDatacenter;
import org.cloudsimplus.network.HostPacket;
import org.cloudsimplus.network.switches.AbstractSwitch;
import org.cloudsimplus.network.switches.EdgeSwitch;
import org.cloudsimplus.network.switches.Switch;
import org.cloudsimplus.util.BytesConversion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootSwitch
extends AbstractSwitch {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)RootSwitch.class.getSimpleName());
    public static final int LEVEL = 0;
    public static final int PORTS = 1;
    public static final double SWITCHING_DELAY = 0.00285;
    public static final long DOWNLINK_BW = (long)BytesConversion.gigaToMega(320.0);

    public RootSwitch(CloudSimPlus simulation, NetworkDatacenter dc) {
        super(simulation, dc);
        this.setDownlinkBandwidth(DOWNLINK_BW);
        this.setSwitchingDelay(0.00285);
        this.setPorts(1);
    }

    @Override
    protected void processPacketUp(SimEvent evt) {
        super.processPacketUp(evt);
        HostPacket netPkt = (HostPacket)evt.getData();
        EdgeSwitch edgeSwitch = netPkt.getVmEdgeSwitch();
        Optional<Switch> optionalAggrSw = this.findAggregateConnectedToEdgeSwitch(edgeSwitch);
        optionalAggrSw.ifPresentOrElse(aggSw -> this.addPacketToSendToDownlinkSwitch((Switch)aggSw, netPkt), () -> LOGGER.error("No destination switch for this packet"));
    }

    private Optional<Switch> findAggregateConnectedToEdgeSwitch(Switch edgeSwitch) {
        List<Switch> aggregateSwitchList = this.getDownlinkSwitches();
        return aggregateSwitchList.stream().filter(aggregateSw -> this.isEdgeConnectedToAggregatedSwitch(edgeSwitch, (Switch)aggregateSw)).findFirst();
    }

    private boolean isEdgeConnectedToAggregatedSwitch(Switch edgeSwitch, Switch aggregateSw) {
        List<Switch> edgeSwitchList = aggregateSw.getDownlinkSwitches();
        return edgeSwitchList.stream().anyMatch(edgeSwitch::equals);
    }

    @Override
    public int getLevel() {
        return 0;
    }
}

