/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.network.topologies;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.cloudsimplus.network.topologies.TopologicalLink;
import org.cloudsimplus.network.topologies.TopologicalNode;

public class TopologicalGraph {
    private final List<TopologicalLink> linksList = new LinkedList<TopologicalLink>();
    private final List<TopologicalNode> nodeList = new LinkedList<TopologicalNode>();

    public void addLink(TopologicalLink edge) {
        this.linksList.add(Objects.requireNonNull(edge));
    }

    public void addNode(TopologicalNode node) {
        this.nodeList.add(Objects.requireNonNull(node));
    }

    public int getNumberOfNodes() {
        return this.nodeList.size();
    }

    public int getNumberOfLinks() {
        return this.linksList.size();
    }

    public List<TopologicalLink> getLinksList() {
        return Collections.unmodifiableList(this.linksList);
    }

    public List<TopologicalNode> getNodeList() {
        return Collections.unmodifiableList(this.nodeList);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(61);
        builder.append("topological-node-information: ").append(System.lineSeparator());
        for (TopologicalNode node : this.nodeList) {
            builder.append("%d | %s%n".formatted(node.getId(), node.getWorldCoordinates()));
        }
        builder.append("%n%n node-link-information:%n".formatted(new Object[0]));
        for (TopologicalLink link : this.linksList) {
            builder.append("from: %d to: %d delay: %.2f%n".formatted(link.getSrcNodeID(), link.getDestNodeID(), link.getLinkDelay()));
        }
        return builder.toString();
    }
}

