/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.network.topologies.readers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.StringTokenizer;
import java.util.function.Function;
import org.cloudsimplus.network.topologies.TopologicalGraph;
import org.cloudsimplus.network.topologies.readers.ParsingState;
import org.cloudsimplus.network.topologies.readers.TopologyReader;
import org.cloudsimplus.util.ResourceLoader;

public class TopologyReaderBrite
implements TopologyReader {
    private ParsingState state = ParsingState.NOTHING;
    private TopologicalGraph graph;

    void setState(ParsingState state) {
        this.state = state;
    }

    @Override
    public TopologicalGraph readGraphFile(String filename) {
        return this.readGraphFile(ResourceLoader.newInputStreamReader(filename));
    }

    @Override
    public TopologicalGraph readGraphFile(InputStreamReader reader) {
        this.graph = new TopologicalGraph();
        try (BufferedReader buffer = new BufferedReader(reader);){
            buffer.lines().forEach(line -> this.state.parse(this, (String)line));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this.graph;
    }

    <T extends Number> boolean parseLine(String nodeLine, T[] parsedFields, Function<String, T> castFunction) {
        StringTokenizer tokenizer = new StringTokenizer(nodeLine);
        if (!tokenizer.hasMoreElements()) {
            return false;
        }
        for (int i = 0; tokenizer.hasMoreElements() && i < parsedFields.length; ++i) {
            parsedFields[i] = (Number)castFunction.apply(tokenizer.nextToken());
        }
        return true;
    }

    public final TopologicalGraph getGraph() {
        return this.graph;
    }
}

