/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.power;

import lombok.NonNull;

public class PowerMeasurement {
    private final double staticPower;
    private final double dynamicPower;

    public PowerMeasurement(double staticPower, double dynamicPower) {
        this.staticPower = staticPower;
        this.dynamicPower = dynamicPower;
    }

    public PowerMeasurement() {
        this(0.0, 0.0);
    }

    public double getTotalPower() {
        return this.staticPower + this.dynamicPower;
    }

    public PowerMeasurement add(@NonNull PowerMeasurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        return new PowerMeasurement(this.staticPower + measurement.getStaticPower(), this.dynamicPower + measurement.getDynamicPower());
    }

    public PowerMeasurement multiply(double factor) {
        return new PowerMeasurement(this.staticPower * factor, this.dynamicPower * factor);
    }

    public final double getStaticPower() {
        return this.staticPower;
    }

    public final double getDynamicPower() {
        return this.dynamicPower;
    }
}

