/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.power;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import lombok.NonNull;
import org.cloudsimplus.core.CloudSimEntity;
import org.cloudsimplus.core.CloudSimTag;
import org.cloudsimplus.core.Simulation;
import org.cloudsimplus.core.events.SimEvent;
import org.cloudsimplus.power.PowerAware;
import org.cloudsimplus.power.PowerMeasurement;
import org.cloudsimplus.power.models.PowerModel;

public class PowerMeter
extends CloudSimEntity {
    private final Supplier<List<? extends PowerAware<? extends PowerModel>>> powerAwareEntitiesSupplier;
    private double measurementInterval = 1.0;
    private final List<PowerMeasurement> powerMeasurements = new LinkedList<PowerMeasurement>();

    public PowerMeter(Simulation simulation, PowerAware<? extends PowerModel> powerAwareEntity) {
        this(simulation, List.of(powerAwareEntity));
    }

    public PowerMeter(Simulation simulation, List<? extends PowerAware<? extends PowerModel>> powerAwareEntities) {
        this(simulation, () -> powerAwareEntities);
    }

    public PowerMeter(Simulation simulation, @NonNull Supplier<List<? extends PowerAware<? extends PowerModel>>> powerAwareEntitiesSupplier) {
        super(simulation);
        if (powerAwareEntitiesSupplier == null) {
            throw new NullPointerException("powerAwareEntitiesSupplier is marked non-null but is null");
        }
        this.powerAwareEntitiesSupplier = powerAwareEntitiesSupplier;
    }

    @Override
    protected void startInternal() {
        this.schedule(CloudSimTag.POWER_MEASUREMENT);
    }

    @Override
    public void processEvent(SimEvent evt) {
        switch (evt.getTag()) {
            case POWER_MEASUREMENT: {
                this.measurePowerConsumption();
                break;
            }
            case SIMULATION_END: {
                this.shutdown();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Event: " + evt);
            }
        }
    }

    private void measurePowerConsumption() {
        List<? extends PowerAware<? extends PowerModel>> powerAwareEntitiesList = this.powerAwareEntitiesSupplier.get();
        PowerMeasurement measurement = powerAwareEntitiesList.stream().map(PowerAware::getPowerModel).map(PowerModel::getPowerMeasurement).reduce(PowerMeasurement::add).orElse(new PowerMeasurement());
        this.powerMeasurements.add(measurement);
        this.scheduleMeasurement();
    }

    private void scheduleMeasurement() {
        if (this.getSimulation().isThereAnyFutureEvt(evt -> evt.getTag() != CloudSimTag.POWER_MEASUREMENT)) {
            this.schedule(this.measurementInterval, CloudSimTag.POWER_MEASUREMENT);
        }
    }

    public PowerMeter setMeasurementInterval(double measurementInterval) {
        if (measurementInterval <= 0.0) {
            throw new IllegalArgumentException("measurementInterval must be a positive number.");
        }
        this.measurementInterval = measurementInterval;
        return this;
    }

    public final double getMeasurementInterval() {
        return this.measurementInterval;
    }

    public final List<PowerMeasurement> getPowerMeasurements() {
        return this.powerMeasurements;
    }
}

