/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.provisioners;

import java.util.Objects;
import java.util.function.Function;
import org.cloudsimplus.provisioners.ResourceProvisionerAbstract;
import org.cloudsimplus.resources.Pe;
import org.cloudsimplus.resources.Resource;
import org.cloudsimplus.resources.ResourceManageable;
import org.cloudsimplus.vms.Vm;

public class ResourceProvisionerSimple
extends ResourceProvisionerAbstract {
    public ResourceProvisionerSimple() {
        super(ResourceManageable.NULL, vm -> ResourceManageable.NULL);
    }

    protected ResourceProvisionerSimple(ResourceManageable resource, Function<Vm, ResourceManageable> vmResourceFunction) {
        super(resource, vmResourceFunction);
    }

    @Override
    public boolean allocateResourceForVm(Vm vm, long newTotalVmResourceCapacity) {
        Objects.requireNonNull(vm);
        if (!this.isSuitableForVm(vm, newTotalVmResourceCapacity)) {
            return false;
        }
        ResourceManageable vmResource = this.getVmResourceFunction().apply(vm);
        long prevVmResourceAllocation = vmResource.getAllocatedResource();
        if (prevVmResourceAllocation > 0L) {
            this.deallocateResourceForVm(vm);
        }
        if (!this.getPmResource().isSubClassOf(Pe.class) && !vmResource.setCapacity(newTotalVmResourceCapacity)) {
            return false;
        }
        this.getPmResource().allocateResource(newTotalVmResourceCapacity);
        vmResource.setCapacity(newTotalVmResourceCapacity);
        vmResource.setAllocatedResource(newTotalVmResourceCapacity);
        return true;
    }

    @Override
    public boolean allocateResourceForVm(Vm vm, double newTotalVmResource) {
        return this.allocateResourceForVm(vm, (long)newTotalVmResource);
    }

    @Override
    public long deallocateResourceForVm(Vm vm) {
        ResourceManageable vmResource = this.getVmResourceFunction().apply(vm);
        long vmAllocatedResource = vmResource.getAllocatedResource();
        vmResource.deallocateAllResources();
        this.getPmResource().deallocateResource(vmAllocatedResource);
        return vmAllocatedResource;
    }

    @Override
    public boolean isSuitableForVm(Vm vm, long newVmTotalAllocatedResource) {
        long currentAllocatedResource = this.getAllocatedResourceForVm(vm);
        long allocationDifference = newVmTotalAllocatedResource - currentAllocatedResource;
        return this.getPmResource().getAvailableResource() >= allocationDifference;
    }

    @Override
    public boolean isSuitableForVm(Vm vm, Resource resource) {
        return this.isSuitableForVm(vm, resource.getCapacity());
    }
}

