/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.resources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.cloudsimplus.datacenters.Datacenter;
import org.cloudsimplus.resources.File;
import org.cloudsimplus.resources.SanStorage;

public class DatacenterStorage {
    private List<SanStorage> storageList;
    private Datacenter datacenter;

    public DatacenterStorage() {
        this(new ArrayList<SanStorage>());
    }

    public DatacenterStorage(List<SanStorage> storageList) {
        this.setStorageList(storageList);
    }

    public boolean contains(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return this.contains(file.getName());
    }

    public boolean contains(String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return false;
        }
        return this.storageList.stream().anyMatch(storage -> storage.contains(fileName));
    }

    public List<SanStorage> getStorageList() {
        return Collections.unmodifiableList(this.storageList);
    }

    public final DatacenterStorage setStorageList(@NonNull List<SanStorage> storageList) {
        if (storageList == null) {
            throw new NullPointerException("storageList is marked non-null but is null");
        }
        this.storageList = storageList;
        this.setAllFilesOfAllStoragesToThisDatacenter();
        return this;
    }

    private void setAllFilesOfAllStoragesToThisDatacenter() {
        this.storageList.stream().map(SanStorage::getFileList).flatMap(Collection::stream).forEach(file -> file.setDatacenter(this.getDatacenter()));
    }

    public double predictFileTransferTime(List<String> requiredFiles) {
        double totalTime = 0.0;
        for (String fileName : requiredFiles) {
            totalTime += Math.max(this.timeToTransferFileFromStorage(fileName), 0.0);
        }
        return totalTime;
    }

    private double timeToTransferFileFromStorage(String fileName) {
        for (SanStorage storage : this.getStorageList()) {
            double transferTime = storage.getTransferTime(fileName);
            if (transferTime == -1.0) continue;
            return transferTime;
        }
        return -1.0;
    }

    public int addFile(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (this.contains(file.getName())) {
            return 523;
        }
        if (this.getStorageList().isEmpty()) {
            return 521;
        }
        for (SanStorage storage : this.getStorageList()) {
            if (!storage.isAmountAvailable(file.getSize())) continue;
            storage.addFile(file);
            return 520;
        }
        return 521;
    }

    public final Datacenter getDatacenter() {
        return this.datacenter;
    }

    public final DatacenterStorage setDatacenter(Datacenter datacenter) {
        this.datacenter = datacenter;
        return this;
    }
}

