/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.resources;

import java.time.LocalDateTime;
import java.util.Objects;
import lombok.NonNull;
import org.cloudsimplus.resources.File;
import org.cloudsimplus.util.MathUtil;

public class FileAttribute {
    private long id;
    @NonNull
    private String ownerName;
    private int type;
    private int fileSize;
    private int checksum;
    private double lastUpdateTime;
    private LocalDateTime creationTime;
    private double cost;
    private boolean masterCopy;
    @NonNull
    private final File file;

    public FileAttribute(File file, int fileSize) {
        this.file = file;
        this.creationTime = LocalDateTime.now();
        this.ownerName = "";
        this.id = -1L;
        this.type = 0;
        this.masterCopy = true;
        this.setFileSize(fileSize);
    }

    public void copyValue(FileAttribute destinationAttr) {
        Objects.requireNonNull(destinationAttr);
        destinationAttr.setFileSize(this.fileSize);
        destinationAttr.setOwnerName(this.ownerName);
        destinationAttr.setLastUpdateTime(this.lastUpdateTime);
        destinationAttr.setRegistrationId(this.id);
        destinationAttr.setType(this.type);
        destinationAttr.setChecksum(this.checksum);
        destinationAttr.setCost(this.cost);
        destinationAttr.setMasterCopy(this.masterCopy);
        destinationAttr.setCreationTime(this.creationTime);
    }

    public int getAttributeSize() {
        int length = 150000;
        if (this.ownerName != null) {
            length += this.ownerName.length();
        }
        return length += this.file.getName().length();
    }

    public final void setFileSize(int fileSize) {
        if (fileSize <= 0) {
            throw new IllegalArgumentException("File size must be higher than 0");
        }
        this.fileSize = fileSize;
    }

    public int getFileSizeInByte() {
        return this.fileSize * 1000000;
    }

    public boolean setLastUpdateTime(double time) {
        MathUtil.nonNegative(time, "lastUpdateTime");
        if (time < this.lastUpdateTime) {
            return false;
        }
        this.lastUpdateTime = time;
        return true;
    }

    public boolean setRegistrationId(long id) {
        if (id < 0L) {
            return false;
        }
        this.id = id;
        return true;
    }

    public long getRegistrationID() {
        return this.id;
    }

    public void setCost(double cost) {
        this.cost = MathUtil.nonNegative(cost, "cost");
    }

    public boolean isRegistered() {
        return this.id != -1L;
    }

    public final long getId() {
        return this.id;
    }

    @NonNull
    public final String getOwnerName() {
        return this.ownerName;
    }

    public final int getType() {
        return this.type;
    }

    public final int getFileSize() {
        return this.fileSize;
    }

    public final int getChecksum() {
        return this.checksum;
    }

    public final double getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public final LocalDateTime getCreationTime() {
        return this.creationTime;
    }

    public final double getCost() {
        return this.cost;
    }

    public final boolean isMasterCopy() {
        return this.masterCopy;
    }

    @NonNull
    public final File getFile() {
        return this.file;
    }

    public final FileAttribute setOwnerName(@NonNull String ownerName) {
        if (ownerName == null) {
            throw new NullPointerException("ownerName is marked non-null but is null");
        }
        this.ownerName = ownerName;
        return this;
    }

    public final FileAttribute setType(int type) {
        this.type = type;
        return this;
    }

    public final FileAttribute setChecksum(int checksum) {
        this.checksum = checksum;
        return this;
    }

    public final FileAttribute setCreationTime(LocalDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public final FileAttribute setMasterCopy(boolean masterCopy) {
        this.masterCopy = masterCopy;
        return this;
    }
}

